/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemFiltering;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ProgWidgetDroneConditionUpgrades
extends ProgWidgetDroneCondition
implements IItemFiltering {
    public static final MapCodec<ProgWidgetDroneConditionUpgrades> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetDroneConditionUpgrades.droneConditionParts(builder).apply((Applicative)builder, ProgWidgetDroneConditionUpgrades::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetDroneConditionUpgrades> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetDroneCondition.DroneConditionFields.STREAM_CODEC, ProgWidgetDroneCondition::droneConditionFields, ProgWidgetDroneConditionUpgrades::new);

    public ProgWidgetDroneConditionUpgrades() {
    }

    public ProgWidgetDroneConditionUpgrades(ProgWidget.PositionFields pos, ProgWidgetDroneCondition.DroneConditionFields cond) {
        super(pos, cond);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetDroneConditionUpgrades(this.getPosition(), this.droneConditionFields());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.ITEM_FILTER.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected int getCount(IDrone drone, IProgWidget widget) {
        int count = PneumaticRegistry.getInstance().getUpgradeRegistry().getKnownUpgrades().stream().filter(upgrade -> drone.getUpgrades((PNCUpgrade)upgrade) > 0).filter(upgrade -> {
            IItemFiltering f;
            return widget instanceof IItemFiltering && (f = (IItemFiltering)((Object)widget)).isItemValidForFilters(upgrade.getItemStack());
        }).mapToInt(drone::getUpgrades).sum();
        this.maybeRecordMeasuredVal(drone, count);
        return count;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_DRONE_UPGRADES;
    }

    @Override
    public boolean isItemValidForFilters(ItemStack item) {
        return ProgWidgetItemFilter.isItemValidForFilters(item, ProgWidgetDroneConditionUpgrades.getConnectedWidgetList(this, 0, ModProgWidgetTypes.ITEM_FILTER.get()), ProgWidgetDroneConditionUpgrades.getConnectedWidgetList(this, this.getParameters().size(), ModProgWidgetTypes.ITEM_FILTER.get()), null);
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.DRONE_CONDITION_UPGRADES.get();
    }
}

