/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.ArrayList;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetPlace;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class DroneAIPlace<W extends ProgWidgetAreaItemBase>
extends DroneAIBlockInteraction<W> {
    public DroneAIPlace(IDrone drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.drone.getDroneLevel().getBlockState(pos).canBeReplaced()) {
            if (Vec3.atCenterOf((Vec3i)pos).distanceToSqr(this.drone.getDronePos()) < 1.2) {
                return false;
            }
            int slot = this.pickPlaceableSlot();
            if (slot < 0) {
                this.abort();
                return false;
            }
            ItemStack placeableStack = this.drone.getInv().getStackInSlot(slot);
            BlockPos placerPos = this.findClearSide(pos);
            if (placerPos == null) {
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.noClearSides", pos);
            } else {
                Block placingBlock = ((BlockItem)placeableStack.getItem()).getBlock();
                BlockState state = placingBlock.getStateForPlacement(this.getPlacementContext(placerPos, pos, placeableStack));
                if (state == null) {
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.cantPlaceBlock", pos);
                } else if (this.worldCache.isUnobstructed(null, state.getShape((BlockGetter)this.drone.getDroneLevel(), pos))) {
                    if (state.canSurvive((LevelReader)this.drone.getDroneLevel(), pos)) {
                        return true;
                    }
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.cantPlaceBlock", pos);
                } else {
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.entityInWay", pos);
                }
            }
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        if (squareDistToBlock < 4.0) {
            int slot = this.pickPlaceableSlot();
            if (slot >= 0) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(slot);
                BlockItem blockItem = (BlockItem)droneStack.getItem();
                if (this.worldCache.getBlockState(pos).canBeReplaced()) {
                    InteractionResult res;
                    BlockPlaceContext ctx = this.getPlacementContext(pos, pos, droneStack);
                    if (this.progWidget.getCachedAreaSet().contains(ctx.getClickedPos()) && (res = blockItem.place(ctx)).consumesAction()) {
                        this.drone.addAirToDrone(-100);
                        if (slot == 0 && this.drone.getInv().getStackInSlot(slot).isEmpty()) {
                            this.drone.getInv().setStackInSlot(slot, ItemStack.EMPTY);
                        }
                        return false;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private int pickPlaceableSlot() {
        ProgWidgetPlace p;
        ProgWidgetAreaItemBase progWidgetAreaItemBase;
        IItemHandlerModifiable inv = this.drone.getInv();
        if (inv.getSlots() > 1 && (progWidgetAreaItemBase = this.progWidget) instanceof ProgWidgetPlace && (p = (ProgWidgetPlace)progWidgetAreaItemBase).isRandomize()) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack droneStack = inv.getStackInSlot(i);
                if (!(droneStack.getItem() instanceof BlockItem) || !this.progWidget.isItemValidForFilters(droneStack)) continue;
                l.add(i);
            }
            if (!l.isEmpty()) {
                return (Integer)l.get(this.drone.getDroneLevel().random.nextInt(l.size()));
            }
        } else {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack droneStack = inv.getStackInSlot(i);
                if (!(droneStack.getItem() instanceof BlockItem) || !this.progWidget.isItemValidForFilters(droneStack)) continue;
                return i;
            }
        }
        return -1;
    }

    private BlockPos findClearSide(BlockPos pos) {
        for (Direction side : DirectionUtil.VALUES) {
            BlockPos pos2 = pos.relative(side);
            if (!this.drone.getDroneLevel().getBlockState(pos.relative(side)).isPathfindable(PathComputationType.AIR)) continue;
            return pos2;
        }
        return null;
    }

    private BlockPlaceContext getPlacementContext(BlockPos placerPos, BlockPos targetPos, ItemStack droneStack) {
        BlockHitResult brtr = this.drone.getDroneLevel().clip(new ClipContext(Vec3.atCenterOf((Vec3i)placerPos), Vec3.atCenterOf((Vec3i)targetPos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.drone.getFakePlayer()));
        return new BlockPlaceContext((UseOnContext)new DroneBlockItemUseContext((Player)this.drone.getFakePlayer(), droneStack, brtr));
    }

    private static class DroneBlockItemUseContext
    extends UseOnContext {
        protected DroneBlockItemUseContext(Player droneFakePlayer, ItemStack heldItem, BlockHitResult rayTraceResultIn) {
            super(droneFakePlayer.level(), droneFakePlayer, InteractionHand.MAIN_HAND, heldItem, rayTraceResultIn);
        }
    }

    private record SlotAndStack(int slot, ItemStack stack) {
    }
}

