/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.ai.DroneEntityBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class DroneAIEntityImport
extends DroneEntityBase<IEntityProvider, Entity> {
    public DroneAIEntityImport(IDrone drone, IEntityProvider progWidget) {
        super(drone, progWidget);
    }

    @Override
    protected boolean isEntityValid(Entity entity) {
        Player p;
        if (entity instanceof Player && (p = (Player)entity).isSpectator()) {
            return false;
        }
        if (entity instanceof LivingEntity || entity instanceof AbstractMinecart || entity instanceof Boat) {
            return this.drone.getCarryingEntities().isEmpty();
        }
        if (((Boolean)ConfigHelper.common().drones.dronesCanImportXPOrbs.get()).booleanValue() && entity instanceof ExperienceOrb) {
            return PneumaticCraftUtils.fillTankWithOrb((IFluidHandler)this.drone.getFluidTank(), (ExperienceOrb)entity, IFluidHandler.FluidAction.SIMULATE);
        }
        return false;
    }

    @Override
    protected boolean doAction() {
        Entity entity;
        if (((Boolean)ConfigHelper.common().drones.dronesCanImportXPOrbs.get()).booleanValue() && (entity = this.targetedEntity) instanceof ExperienceOrb) {
            ExperienceOrb orb = (ExperienceOrb)entity;
            ItemStack heldStack = this.drone.getInv().getStackInSlot(0);
            if (!heldStack.isEmpty() && heldStack.isDamaged() && EnchantmentHelper.has((ItemStack)heldStack, (DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP)) {
                int toRepair = Math.min((int)((float)orb.value * heldStack.getXpRepairRatio()), heldStack.getDamageValue());
                orb.value -= toRepair / 2;
                heldStack.setDamageValue(heldStack.getDamageValue() - toRepair);
            }
            if (orb.value <= 0 || PneumaticCraftUtils.fillTankWithOrb((IFluidHandler)this.drone.getFluidTank(), orb, IFluidHandler.FluidAction.EXECUTE)) {
                this.targetedEntity.discard();
            }
        } else {
            this.drone.setCarryingEntity(this.targetedEntity);
        }
        return false;
    }
}

