/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone;

import me.desht.pneumaticcraft.common.drone.EntityPathNavigateDrone;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;

public class DroneMovementController
extends MoveControl {
    private final AbstractDroneEntity entity;
    private double x;
    private double y;
    private double z;
    private double speed;
    private int timeoutTimer;
    private int timeoutCounter;

    public DroneMovementController(AbstractDroneEntity par1EntityLiving) {
        super((Mob)par1EntityLiving);
        this.entity = par1EntityLiving;
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.z = this.entity.getZ();
    }

    public void setWantedPosition(double x, double y, double z, double speed) {
        double newY = y + 0.5 - 0.17;
        if (x != this.x || newY != this.y || z != this.z) {
            this.x = x;
            this.y = newY;
            this.z = z;
            this.timeoutTimer = 0;
        } else {
            this.timeoutCounter = 0;
        }
        this.speed = speed;
    }

    public void tick() {
        if (!(this.entity.getNavigation() instanceof EntityPathNavigateDrone)) {
            return;
        }
        if (this.entity.isAccelerating()) {
            this.entity.setDeltaMovement(Math.max(-this.speed, Math.min(this.speed, this.x - this.entity.getX())), Math.max(-this.speed, Math.min(this.speed, this.y - this.entity.getY())), Math.max(-this.speed, Math.min(this.speed, this.z - this.entity.getZ())));
            EntityPathNavigateDrone navigator = (EntityPathNavigateDrone)this.entity.getNavigation();
            if (!navigator.isGoingToTeleport() && this.timeoutTimer++ > 40) {
                this.entity.getNavigation().stop();
                this.timeoutTimer = 0;
                ++this.timeoutCounter;
                if (this.timeoutCounter > 1 && this.entity.isPathFinding()) {
                    navigator.teleport();
                }
            }
        }
    }
}

