/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.block.entity.processing.UVLightBoxBlockEntity;
import me.desht.pneumaticcraft.common.inventory.EtchingTankMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.EmptyPCBItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class EtchingTankBlockEntity
extends AbstractTickingBlockEntity
implements MenuProvider,
ISerializableTanks,
IHeatExchangingTE {
    public static final int ETCHING_SLOTS = 25;
    private final EtchingTankHandler itemHandler = new EtchingTankHandler(this);
    private final OutputItemHandler outputHandler = new OutputItemHandler(this);
    private final FailedItemHandler failedHandler = new FailedItemHandler(this);
    private final WrappedInvHandler sideHandler = new WrappedInvHandler((IItemHandler)this.outputHandler);
    private final WrappedInvHandler endHandler = new WrappedInvHandler((IItemHandler)this.failedHandler);
    @DescSynced
    @GuiSynced
    private final EtchingFluidTank acidTank = new EtchingFluidTank(this);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();

    public EtchingTankBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.ETCHING_TANK.get(), pos, state);
        this.heatExchanger.setThermalResistance(10.0);
        this.heatExchanger.setThermalCapacity(5.0);
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction dir) {
        return this.acidTank;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.acidTank.tick();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (!this.acidTank.getFluid().isEmpty()) {
            int tickInterval = this.getTickInterval();
            Level level = this.nonNullLevel();
            if (level.getGameTime() % (long)tickInterval == 0L) {
                boolean didWork = false;
                for (int i = 0; i < 25; ++i) {
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    int etchProgress = EmptyPCBItem.getEtchProgress(stack);
                    if (etchProgress < 100) {
                        EmptyPCBItem.setEtchProgress(stack, etchProgress + 1);
                        didWork = true;
                        continue;
                    }
                    if (this.isOutputFull() || this.isFailedOutputFull()) continue;
                    int uvProgress = UVLightBoxBlockEntity.getExposureProgress(stack);
                    boolean success = level.random.nextInt(100) <= uvProgress;
                    this.tryMoveFinishedItem(i, success);
                }
                if (didWork && tickInterval < 30) {
                    if (level.random.nextInt(100) < 30 - tickInterval) {
                        this.acidTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.heatExchanger.addHeat(-(30 - tickInterval));
                }
            }
        }
    }

    public int getTickInterval() {
        int delta = Mth.clamp((int)(this.heatExchanger.getTemperatureAsInt() - 323), (int)0, (int)480);
        return 30 - (delta + 1) / 20;
    }

    private void tryMoveFinishedItem(int slot, boolean success) {
        ItemStack inputStack = this.itemHandler.extractItem(slot, 1, true);
        if (!inputStack.isEmpty()) {
            ItemStack result = this.getResultItem(inputStack, success);
            ItemStack excess = success ? this.outputHandler.insertItem(0, result, false) : this.failedHandler.insertItem(0, result, false);
            if (excess.isEmpty()) {
                this.itemHandler.extractItem(slot, 1, false);
            }
        }
    }

    private ItemStack getResultItem(ItemStack inputStack, boolean success) {
        Item item = inputStack.getItem();
        if (item instanceof EmptyPCBItem) {
            EmptyPCBItem emptyPCB = (EmptyPCBItem)item;
            return success ? emptyPCB.getSuccessItem() : emptyPCB.getFailedItem();
        }
        return success ? ((EmptyPCBItem)ModItems.EMPTY_PCB.get()).getSuccessItem() : ((EmptyPCBItem)ModItems.EMPTY_PCB.get()).getFailedItem();
    }

    public boolean isOutputFull() {
        ItemStack stack = this.outputHandler.getStackInSlot(0);
        return stack.getCount() >= stack.getMaxStackSize();
    }

    public boolean isFailedOutputFull() {
        ItemStack stack = this.failedHandler.getStackInSlot(0);
        return stack.getCount() >= stack.getMaxStackSize();
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        if (dir == null) {
            return this.itemHandler;
        }
        if (dir.getAxis() == Direction.Axis.Y) {
            return this.endHandler;
        }
        return this.sideHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputHandler;
    }

    public IItemHandler getFailedHandler() {
        return this.failedHandler;
    }

    public IFluidTank getAcidTank() {
        return this.acidTank;
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        super.getContentsToDrop(drops);
        PneumaticCraftUtils.collectNonEmptyItems((IItemHandler)this.outputHandler, drops);
        PneumaticCraftUtils.collectNonEmptyItems((IItemHandler)this.failedHandler, drops);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
        return new EtchingTankMenu(windowId, playerInv, this.getBlockPos());
    }

    @Override
    @Nonnull
    public Map<DataComponentType<SimpleFluidContent>, PNCFluidTank> getSerializableTanks() {
        return Map.of(ModDataComponents.MAIN_TANK.get(), this.acidTank);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Inventory", (Tag)this.itemHandler.serializeNBT(provider));
        tag.put("Output", (Tag)this.outputHandler.serializeNBT(provider));
        tag.put("Failed", (Tag)this.failedHandler.serializeNBT(provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.itemHandler.deserializeNBT(provider, tag.getCompound("Inventory"));
        this.outputHandler.deserializeNBT(provider, tag.getCompound("Output"));
        this.failedHandler.deserializeNBT(provider, tag.getCompound("Failed"));
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }

    private class EtchingTankHandler
    extends BaseItemStackHandler {
        EtchingTankHandler(EtchingTankBlockEntity etchingTankBlockEntity) {
            super(etchingTankBlockEntity, 25);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getItem() instanceof EmptyPCBItem && UVLightBoxBlockEntity.getExposureProgress(stack) > 0;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }

    private class OutputItemHandler
    extends BaseItemStackHandler {
        OutputItemHandler(EtchingTankBlockEntity etchingTankBlockEntity) {
            super(etchingTankBlockEntity, 1);
        }
    }

    private class FailedItemHandler
    extends BaseItemStackHandler {
        FailedItemHandler(EtchingTankBlockEntity etchingTankBlockEntity) {
            super(etchingTankBlockEntity, 1);
        }
    }

    private class WrappedInvHandler
    implements IItemHandler {
        private final IItemHandler output;

        WrappedInvHandler(IItemHandler output) {
            this.output = output;
        }

        public int getSlots() {
            return 26;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? this.output.getStackInSlot(0) : EtchingTankBlockEntity.this.itemHandler.getStackInSlot(slot - 1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot == 0 ? stack : EtchingTankBlockEntity.this.itemHandler.insertItem(slot - 1, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 0 ? this.output.extractItem(0, amount, simulate) : ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? this.output.getSlotLimit(0) : EtchingTankBlockEntity.this.itemHandler.getSlotLimit(slot - 1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? this.output.isItemValid(0, stack) : EtchingTankBlockEntity.this.itemHandler.isItemValid(slot - 1, stack);
        }
    }

    private class EtchingFluidTank
    extends SmartSyncTank {
        EtchingFluidTank(EtchingTankBlockEntity etchingTankBlockEntity) {
            super(etchingTankBlockEntity, 4000);
        }

        @Override
        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().isSame(EmptyPCBItem.getEtchingFluid().getFluid());
        }
    }
}

