/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.tube.TubeJunctionBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TubeJunctionBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.box((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0), Block.box((double)3.0, (double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final Map<Direction.Axis, VoxelShape> SHAPES = new EnumMap<Direction.Axis, VoxelShape>(Direction.Axis.class);

    public TubeJunctionBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.AXIS});
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES.get(pState.getValue((Property)BlockStateProperties.AXIS));
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (player != null && player.isCrouching()) {
            return super.onWrenched(world, player, pos, side, hand);
        }
        BlockState state = world.getBlockState(pos);
        Direction.Axis newAxis = Direction.Axis.values()[(((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)).ordinal() + 1) % Direction.Axis.values().length];
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)newAxis));
        world.getBlockEntity(pos, ModBlockEntityTypes.TUBE_JUNCTION.get()).ifPresent(AbstractAirHandlingBlockEntity::onBlockRotated);
        return true;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        return state == null ? null : (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)ctx.getClickedFace().getAxis());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TubeJunctionBlockEntity(pPos, pState);
    }

    static {
        SHAPES.put(Direction.Axis.Y, SHAPE);
        SHAPES.put(Direction.Axis.Z, VoxelShapeUtils.rotateX(SHAPE, 90));
        SHAPES.put(Direction.Axis.X, VoxelShapeUtils.rotateY(SHAPES.get(Direction.Axis.Z), 90));
    }
}

