/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.heat.HeatSinkBlockEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HeatSinkBlock
extends AbstractPneumaticCraftBlock
implements ColorHandlers.IHeatTintable,
PneumaticCraftEntityBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public HeatSinkBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return SHAPES[this.getRotation(state).get3DDataValue()];
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        return state == null ? null : (BlockState)state.setValue((Property)this.directionProperty(), (Comparable)ctx.getClickedFace().getOpposite());
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos, HeatSinkBlockEntity.class).ifPresent(te -> {
            double temp = te.getHeatExchanger().getTemperature();
            if (temp > 333.0) {
                entity.hurt(entity.damageSources().hotFloor(), 1.0f + ((float)temp - 333.0f) * 0.05f);
                if (temp > 373.0) {
                    entity.igniteForSeconds(3.0f);
                }
            } else if (temp < 243.0) {
                entity.setIsInPowderSnow(true);
                if (temp < 213.0) {
                    boolean canFreeze = entity.canFreeze();
                    int amplifier = (int)((243.0 - temp) / 20.0) + (canFreeze ? 0 : 3);
                    entity.setTicksFrozen(Math.min(entity.getTicksFrozen() + amplifier, entity.getTicksRequiredToFreeze() + 2));
                    if (entity.getTicksFrozen() >= entity.getTicksRequiredToFreeze()) {
                        float dmg;
                        int durationTicks = (int)((243.0 - temp) * 2.0);
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, durationTicks, amplifier));
                        float f = dmg = entity.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES) ? 5.0f : 2.0f;
                        if (!canFreeze) {
                            dmg /= 2.0f;
                        }
                        entity.hurt(entity.damageSources().freeze(), dmg);
                    }
                }
            }
        });
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new HeatSinkBlockEntity(pPos, pState);
    }
}

