/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record PointXY(int x, int y) {
    public static final Codec<PointXY> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("x").forGetter(PointXY::x), (App)Codec.INT.fieldOf("y").forGetter(PointXY::y)).apply((Applicative)builder, PointXY::new));
    public static final StreamCodec<ByteBuf, PointXY> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PointXY::x, (StreamCodec)ByteBufCodecs.INT, PointXY::y, PointXY::new);
    public static final PointXY ZERO = new PointXY(0, 0);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PointXY)) {
            return false;
        }
        PointXY pointXY = (PointXY)o;
        return this.x == pointXY.x && this.y == pointXY.y;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public double distance(PointXY p2) {
        double px = p2.x - this.x;
        double py = p2.y - this.y;
        return Math.sqrt(px * px + py * py);
    }

    public PointXY add(int x, int y) {
        return new PointXY(this.x + x, this.y + y);
    }
}

