/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.semiblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.model.entity.semiblocks.ModelLogisticsFrame;
import me.desht.pneumaticcraft.client.render.entity.semiblock.RenderSemiblockBase;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RenderLogisticsFrame
extends RenderSemiblockBase<AbstractLogisticsFrameEntity> {
    private final ModelLogisticsFrame model;

    public RenderLogisticsFrame(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new ModelLogisticsFrame(ctx.bakeLayer(PNCModelLayers.LOGISTICS_FRAME));
    }

    public void render(AbstractLogisticsFrameEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Direction side;
        float alpha = (float)entity.getAlpha() / 255.0f;
        if (alpha == 0.0f) {
            return;
        }
        if (entity.isAir()) {
            return;
        }
        matrixStackIn.pushPose();
        if (entity.getTimeSinceHit() > 0) {
            this.wobble(entity, partialTicks, matrixStackIn);
        }
        matrixStackIn.translate(0.0, (side = entity.getSide()).getAxis() == Direction.Axis.Y ? 0.5 : -0.5, 0.0);
        switch (side) {
            case UP: {
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
                matrixStackIn.translate(0.0f, -1.0f, 0.0f);
                break;
            }
            case DOWN: {
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                matrixStackIn.translate(0.0f, -1.0f, 0.0f);
                break;
            }
            case NORTH: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case WEST: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
        }
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity)));
        int color = FastColor.ARGB32.color((int)((int)(255.0f * alpha)), (int)255, (int)255, (int)255);
        this.model.renderToBuffer(matrixStackIn, builder, this.kludgeLightingLevel(entity, packedLightIn), OverlayTexture.pack((float)0.0f, (boolean)false), color);
        matrixStackIn.popPose();
    }

    public Vec3 getRenderOffset(AbstractLogisticsFrameEntity entityIn, float partialTicks) {
        VoxelShape shape = entityIn.getBlockState().getShape((BlockGetter)entityIn.getWorld(), entityIn.getBlockPos());
        double yOff = (shape.max(Direction.Axis.Y) - shape.min(Direction.Axis.Y)) / 2.0;
        return switch (entityIn.getSide()) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new Vec3(0.0, shape.min(Direction.Axis.Y), 0.0);
            case Direction.UP -> new Vec3(0.0, shape.max(Direction.Axis.Y) - 1.0, 0.0);
            case Direction.NORTH -> new Vec3(0.0, yOff - 0.5, shape.min(Direction.Axis.Z));
            case Direction.SOUTH -> new Vec3(0.0, yOff - 0.5, shape.max(Direction.Axis.Z) - 1.0);
            case Direction.WEST -> new Vec3(shape.min(Direction.Axis.X), yOff - 0.5, 0.0);
            case Direction.EAST -> new Vec3(shape.max(Direction.Axis.X) - 1.0, yOff - 0.5, 0.0);
        };
    }

    public ResourceLocation getTextureLocation(AbstractLogisticsFrameEntity entityLogisticsFrame) {
        return entityLogisticsFrame.getTexture();
    }
}

