/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.JetBootsOptions;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketJetBootsActivate;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.JetBootsHandler;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;

public class JetBootsClientHandler
extends IArmorUpgradeClientHandler.SimpleToggleableHandler<JetBootsHandler> {
    private static final ItemStack PICK = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
    private static final ItemStack ROTOR = new ItemStack((ItemLike)ModItems.TURBINE_ROTOR.get());
    private static final ItemStack ELYTRA = new ItemStack((ItemLike)Items.ELYTRA);
    private static final ItemStack FEATHER = new ItemStack((ItemLike)Items.FEATHER);
    private static final String[] HEADINGS = new String[]{"S", "SW", "W", "NW", "N", "NE", "E", "SE"};
    public static final ResourceLocation MODULE_BUILDER_MODE = PneumaticRegistry.RL("jet_boots.module.builder_mode");
    public static final ResourceLocation MODULE_FLIGHT_STABILIZERS = PneumaticRegistry.RL("jet_boots.module.flight_stabilizers");
    public static final ResourceLocation MODULE_HOVER = PneumaticRegistry.RL("jet_boots.module.hover");
    public static final ResourceLocation MODULE_SMART_HOVER = PneumaticRegistry.RL("jet_boots.module.smart_hover");
    private static final StatPanelLayout DEFAULT_STAT_LAYOUT = StatPanelLayout.expandsRight(0.5f, 0.005f);
    private String l1;
    private String l2;
    private String l3;
    private String r1;
    private String r2;
    private String r3;
    private int widestR;
    private boolean builderMode;
    private boolean flightStabilizers;
    private boolean smartHover;
    private double prevX;
    private double prevY;
    private double prevZ;
    private boolean suppressed;
    private IGuiAnimatedStat jbStat;

    public JetBootsClientHandler() {
        super(CommonUpgradeHandlers.jetBootsHandler);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new JetBootsOptions(screen, this);
    }

    @Override
    public boolean isEnabledByDefault(String subModuleName) {
        return subModuleName.equals(MODULE_HOVER.getPath());
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler, boolean isEnabled) {
        JetBootsHandler jbHandler = CommonUpgradeHandlers.jetBootsHandler;
        JetBootsStateTracker.JetBootsState jbState = jbHandler.getJetBootsSyncedState(armorHandler);
        if (armorHandler.upgradeUsable(jbHandler, false)) {
            if (!(!jbState.isActive() || jbState.isEnabled() && JetBootsClientHandler.thrustKeyPressed(jbState.isBuilderMode()))) {
                NetworkHandler.sendToServer(new PacketJetBootsActivate(false));
                jbHandler.setJetBootsActive(armorHandler, false);
            } else if (!jbState.isActive() && jbState.isEnabled() && JetBootsClientHandler.thrustKeyPressed(jbState.isBuilderMode())) {
                NetworkHandler.sendToServer(new PacketJetBootsActivate(true));
                jbHandler.setJetBootsActive(armorHandler, true);
            }
        }
        if (!isEnabled) {
            return;
        }
        if (this.jbStat.isStatOpen()) {
            this.suppressed = CommonArmorHandler.getHandlerForPlayer().isOnCooldown(EquipmentSlot.FEET);
            String g1 = this.suppressed ? ChatFormatting.GRAY.toString() : ChatFormatting.WHITE.toString();
            String g2 = this.suppressed ? ChatFormatting.RED.toString() : ChatFormatting.GREEN.toString();
            Player player = armorHandler.getPlayer();
            double mx = player.getX() - this.prevX;
            double my = player.getY() - this.prevY;
            double mz = player.getZ() - this.prevZ;
            this.prevX = player.getX();
            this.prevY = player.getY();
            this.prevZ = player.getZ();
            double v = Math.sqrt(mx * mx + my * my + mz * mz);
            double vg = Math.sqrt(mx * mx + mz * mz);
            int heading = Mth.floor((double)((double)(player.getYRot() * 8.0f / 360.0f) + 0.5)) & 7;
            int yaw = ((int)player.getYRot() + 180) % 360;
            if (yaw < 0) {
                yaw += 360;
            }
            BlockPos pos = player.blockPosition();
            this.l1 = String.format(" %sSpd: %s%05.2fm/s", g1, g2, v * 20.0);
            this.l2 = String.format("  %sAlt: %s%03dm", g1, g2, pos.getY());
            this.l3 = String.format("%sHead: %s%d\u00b0 (%s)", g1, g2, yaw, HEADINGS[heading]);
            this.r1 = String.format("%sGnd: %s%05.2f", g1, g2, vg * 20.0);
            this.r2 = String.format("%sGnd: %s%dm", g1, g2, pos.getY() - player.level().getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()));
            this.r3 = String.format("%sPch: %s%d\u00b0", g1, g2, (int)(-player.getXRot()));
            Font fr = Minecraft.getInstance().font;
            this.widestR = Math.max(fr.width(this.r1), Math.max(fr.width(this.r2), fr.width(this.r3)));
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
            this.builderMode = jbState.isBuilderMode();
            JetBootsHandler.JetBootsLocalState jbLocal = (JetBootsHandler.JetBootsLocalState)handler.getExtensionData(this.getCommonHandler());
            this.flightStabilizers = jbLocal.isFlightStabilizers();
            this.smartHover = jbLocal.isSmartHover();
        }
    }

    @Override
    public void render2D(GuiGraphics graphics, float partialTicks, boolean armorPieceHasPressure) {
        if (armorPieceHasPressure && this.jbStat.isStatOpen() && !ArmorHUDLayout.INSTANCE.getLayoutFor(this.getID(), this.getDefaultStatLayout()).hidden()) {
            int color;
            Font fr = Minecraft.getInstance().font;
            int xl = this.jbStat.getBaseX() + 5;
            int n = this.jbStat.getBaseY();
            Objects.requireNonNull(fr);
            int y = n + 9 + 8;
            int xr = this.jbStat.getBaseX() + this.jbStat.getStatWidth() - 5;
            if (this.jbStat.isLeftSided()) {
                xl -= this.jbStat.getStatWidth();
                xr -= this.jbStat.getStatWidth();
            }
            if (xl >= Minecraft.getInstance().getWindow().getGuiScaledWidth() || xr <= 0) {
                return;
            }
            int n2 = color = this.suppressed ? 0x202020 : 0x404040;
            if (!this.suppressed || (Minecraft.getInstance().level.getGameTime() & 0xFL) > 2L) {
                graphics.drawString(fr, this.l1, xl, y, color);
                Objects.requireNonNull(fr);
                graphics.drawString(fr, this.l2, xl, y + 9, color);
                Objects.requireNonNull(fr);
                graphics.drawString(fr, this.l3, xl, y + 9 * 2, color);
                graphics.drawString(fr, this.r1, xr - this.widestR, y, color);
                Objects.requireNonNull(fr);
                graphics.drawString(fr, this.r2, xr - this.widestR, y + 9, color);
                Objects.requireNonNull(fr);
                graphics.drawString(fr, this.r3, xr - this.widestR, y + 9 * 2, color);
            }
            int iconX = xr - 30;
            if (this.builderMode) {
                graphics.renderItem(PICK, iconX, this.jbStat.getBaseY());
                iconX -= 16;
            }
            if (this.flightStabilizers) {
                graphics.renderItem(ROTOR, iconX, this.jbStat.getBaseY());
                iconX -= 16;
            }
            if (ClientUtils.getClientPlayer().isFallFlying()) {
                graphics.renderItem(ELYTRA, iconX, this.jbStat.getBaseY());
                iconX -= 16;
            }
            if (this.smartHover) {
                graphics.renderItem(FEATHER, iconX, this.jbStat.getBaseY());
            }
        }
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.jbStat == null) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                this.prevX = player.getX();
                this.prevY = player.getY();
                this.prevZ = player.getZ();
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
            int n = Math.max(1, handler.getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.JET_BOOTS.get()));
            ItemStack stack = new ItemStack((ItemLike)ModUpgrades.JET_BOOTS.get().getItem(n));
            this.jbStat = ClientArmorRegistry.getInstance().makeHUDStatPanel((Component)PneumaticCraftUtils.xlate(IArmorUpgradeHandler.getStringKey(this.getID()), new Object[0]), stack, this);
            this.jbStat.setMinimumContractedDimensions(0, 0);
            this.jbStat.setMinimumExpandedDimensions(120, 42);
        }
        return this.jbStat;
    }

    @Override
    public StatPanelLayout getDefaultStatLayout() {
        return DEFAULT_STAT_LAYOUT;
    }

    @Override
    public void onResolutionChanged() {
        this.jbStat = null;
    }

    @Override
    public Collection<ResourceLocation> getSubKeybinds() {
        return ImmutableList.of((Object)MODULE_BUILDER_MODE, (Object)MODULE_FLIGHT_STABILIZERS, (Object)MODULE_HOVER, (Object)MODULE_SMART_HOVER);
    }

    private static boolean thrustKeyPressed(boolean builderMode) {
        return KeyHandler.getInstance().keybindJetBoots.isDown() || builderMode && Minecraft.getInstance().options.keyJump.isDown();
    }
}

