/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableBlock;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.HackClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTrackEntryHackable
implements IBlockTrackEntry {
    public static final ResourceLocation ID = PneumaticRegistry.RL("block_tracker.module.hackables");

    @Override
    public boolean shouldTrackWithThisEntry(Level world, BlockPos pos, BlockState state, BlockEntity te) {
        return HackClientHandler.enabledForPlayer(ClientUtils.getClientPlayer()) && HackManager.getHackableForBlock(world, pos, ClientUtils.getClientPlayer()) != null;
    }

    @Override
    public List<BlockPos> getServerUpdatePositions(BlockEntity te) {
        return Collections.emptyList();
    }

    @Override
    public int spamThreshold() {
        return 10;
    }

    @Override
    public void addInformation(Level world, BlockPos pos, BlockEntity te, Direction face, List<Component> infoList) {
        Player player = ClientUtils.getClientPlayer();
        IHackableBlock hackableBlock = HackManager.getHackableForBlock(world, pos, player);
        assert (hackableBlock != null);
        int hackTime = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.blockTrackerHandler, BlockTrackerClientHandler.class).getTargetForCoord(pos).getHackTime();
        if (hackTime == 0) {
            hackableBlock.addInfo((BlockGetter)world, pos, infoList, player);
            HackClientHandler.addKeybindTooltip(infoList);
        } else {
            int requiredHackTime = hackableBlock.getHackTime((BlockGetter)world, pos, player);
            int percentageComplete = hackTime * 100 / requiredHackTime;
            if (percentageComplete < 100) {
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.hacking", percentageComplete));
            } else if (hackTime < requiredHackTime + 20) {
                hackableBlock.addPostHackInfo((BlockGetter)world, pos, infoList, player);
            } else {
                hackableBlock.addInfo((BlockGetter)world, pos, infoList, player);
                HackClientHandler.addKeybindTooltip(infoList);
            }
        }
    }

    @Override
    public ResourceLocation getEntryID() {
        return ID;
    }
}

