/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.particle;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;

public class AirParticle
extends TextureSheetParticle {
    private final SpriteSet sprite;

    private AirParticle(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, float scale, SpriteSet sprite) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.sprite = sprite;
        this.lifetime = 50;
        this.quadSize = scale;
        this.xd = xSpeedIn + worldIn.random.nextDouble() * 0.1 - 0.05;
        this.yd = ySpeedIn + worldIn.random.nextDouble() * 0.1 - 0.05;
        this.zd = zSpeedIn + worldIn.random.nextDouble() * 0.1 - 0.05;
        this.setSpriteFromAge(sprite);
    }

    public void tick() {
        super.tick();
        if (!this.level.isEmptyBlock(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)) || this.onGround) {
            this.remove();
        }
        this.setSpriteFromAge(this.sprite);
        this.scale(1.03f);
        this.alpha *= 0.975f;
        if (this.level.random.nextInt(10) == 0) {
            this.xd += this.level.random.nextDouble() * 0.08 - 0.04;
        }
        if (this.level.random.nextInt(10) == 0) {
            this.yd += this.level.random.nextDouble() * 0.08 - 0.04;
        }
        if (this.level.random.nextInt(10) == 0) {
            this.yd += this.level.random.nextDouble() * 0.08 - 0.04;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<AirParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(AirParticleData airParticleData, ClientLevel world, double x, double y, double z, double dx, double dy, double dz) {
            AirParticle p = new AirParticle(world, x, y, z, dx, dy, dz, 0.2f, this.spriteSet);
            p.setAlpha(airParticleData.alpha());
            return p;
        }
    }
}

