/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class WidgetFluidStack
extends AbstractWidget {
    private static final float TEXT_SCALE = 0.5f;
    final Consumer<WidgetFluidStack> pressable;
    private FluidStack fluidStack;
    private boolean adjustable = false;
    private boolean showAmount = false;

    public WidgetFluidStack(int x, int y, Fluid fluid, Consumer<WidgetFluidStack> pressable) {
        this(x, y, new FluidStack(fluid, 1000), pressable);
    }

    public WidgetFluidStack(int x, int y, FluidStack fluidStack, Consumer<WidgetFluidStack> pressable) {
        super(x, y, 16, 16, (Component)Component.empty());
        this.pressable = pressable;
        this.fluidStack = fluidStack;
    }

    public WidgetFluidStack setAdjustable() {
        this.adjustable = true;
        return this;
    }

    public WidgetFluidStack setShowAmount() {
        this.showAmount = true;
        return this;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public WidgetFluidStack setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    public Fluid getFluid() {
        return this.fluidStack.getFluid();
    }

    public WidgetFluidStack setFluid(Fluid fluid) {
        this.fluidStack = fluid == Fluids.EMPTY ? FluidStack.EMPTY : new FluidStack(fluid, 1000);
        return this;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.fluidStack.isEmpty()) {
            GuiUtils.drawFluid(graphics, new Rect2i(this.getX(), this.getY(), 16, 16), this.fluidStack.copyWithAmount(1000), null);
            if (this.adjustable || this.showAmount) {
                Font font = Minecraft.getInstance().font;
                MutableComponent str = Component.literal((String)String.format("%.1fB", Float.valueOf((float)this.fluidStack.getAmount() / 1000.0f)));
                graphics.pose().translate(0.0f, 0.0f, 200.0f);
                int n = (int)((float)this.getX() - (float)font.width((FormattedText)str) * 0.5f + 16.0f);
                float f = this.getY() + 16;
                Objects.requireNonNull(font);
                GuiUtils.drawScaledText(graphics, font, (Component)str, n, (int)(f - 9.0f * 0.5f), 0xFFFFFF, 0.5f, true);
                graphics.pose().translate(0.0f, 0.0f, -200.0f);
            }
            MutableComponent c = this.fluidStack.copyWithAmount(1).getHoverName().copy();
            if (this.adjustable || this.showAmount) {
                c.append("\n").append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.fluidmB", this.fluidStack.getAmount()).withStyle(ChatFormatting.GRAY));
            }
            c.append("\n").append((Component)Component.literal((String)ModNameCache.getModName(this.fluidStack.getFluid())).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
            this.setTooltip(Tooltip.create((Component)c));
        } else {
            this.setTooltip(null);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.clicked(mouseX, mouseY)) {
            if (!this.fluidStack.isEmpty() && this.adjustable) {
                boolean shift = Screen.hasShiftDown();
                switch (button) {
                    case 0: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() / 2 : Math.max(0, this.fluidStack.getAmount() - 1000));
                        if (this.fluidStack.getAmount() >= 1000) break;
                        this.fluidStack.setAmount(0);
                        break;
                    }
                    case 1: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() * 2 : this.fluidStack.getAmount() + 1000);
                        break;
                    }
                    case 2: {
                        this.fluidStack.setAmount(0);
                    }
                }
            }
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.clicked(pMouseX, pMouseY)) {
            int incr = 0;
            if (!this.fluidStack.isEmpty() && this.adjustable) {
                int n = incr = pScrollY > 0.0 ? 1000 : -1000;
                if (Screen.hasShiftDown()) {
                    incr /= 10;
                }
            }
            if (incr != 0) {
                int newAmount = Math.max(0, this.fluidStack.getAmount() + incr);
                this.fluidStack.setAmount(newAmount);
                if (this.pressable != null) {
                    this.pressable.accept(this);
                }
                return true;
            }
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void onClick(double x, double y, int button) {
        super.onClick(x, y, button);
        if (this.pressable != null) {
            this.pressable.accept(this);
        }
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

