/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.gui.widget.ITaggedWidget;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

public class WidgetButtonExtended
extends ExtendedButton
implements ITaggedWidget {
    private int iconSpacing = 18;
    private Supplier<List<Component>> tooltipSupplier;
    private ItemStack[] renderedStacks;
    private ResourceLocation resLoc;
    private int invisibleHoverColor;
    private boolean thisVisible = true;
    private IconPosition iconPosition = IconPosition.MIDDLE;
    private Supplier<String> tagSupplier = () -> null;
    private boolean renderStackSize = false;
    private boolean highlightInactive = false;

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, Component buttonText, Button.OnPress pressable) {
        super(startX, startY, xSize, ySize, buttonText, pressable);
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, Component buttonText) {
        this(startX, startY, xSize, ySize, buttonText, b -> {});
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, String buttonText, Button.OnPress pressable) {
        super(startX, startY, xSize, ySize, (Component)Component.literal((String)buttonText), pressable);
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, String buttonText) {
        this(startX, startY, xSize, ySize, buttonText, b -> {});
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize) {
        this(startX, startY, xSize, ySize, (Component)Component.empty(), b -> {});
    }

    public WidgetButtonExtended withTag(String tag) {
        this.tagSupplier = () -> tag;
        return this;
    }

    public WidgetButtonExtended withTag(Supplier<String> tagSupplier) {
        this.tagSupplier = tagSupplier;
        return this;
    }

    public WidgetButtonExtended withCustomTooltip(Supplier<List<Component>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public void onPress() {
        super.onPress();
        String tag1 = this.getTag();
        if (tag1 != null && !tag1.isEmpty()) {
            NetworkHandler.sendToServer(new PacketGuiButton(tag1));
        }
    }

    @Override
    public String getTag() {
        return this.tagSupplier.get();
    }

    public WidgetButtonExtended setVisible(boolean visible) {
        this.thisVisible = visible;
        return this;
    }

    public WidgetButtonExtended setInvisibleHoverColor(int color) {
        this.invisibleHoverColor = color;
        return this;
    }

    public WidgetButtonExtended setIconPosition(IconPosition iconPosition) {
        this.iconPosition = iconPosition;
        return this;
    }

    public WidgetButtonExtended setRenderStacks(ItemStack ... renderedStacks) {
        this.renderedStacks = renderedStacks;
        this.resLoc = null;
        return this;
    }

    public WidgetButtonExtended setRenderedIcon(ResourceLocation resLoc) {
        this.resLoc = resLoc;
        this.renderedStacks = null;
        return this;
    }

    public WidgetButtonExtended setIconSpacing(int spacing) {
        this.iconSpacing = spacing;
        return this;
    }

    public WidgetButtonExtended setTexture(Either<ItemStack, ResourceLocation> texture) {
        texture.ifLeft(xva$0 -> this.setRenderStacks((ItemStack)xva$0)).ifRight(this::setRenderedIcon);
        return this;
    }

    public void setHighlightWhenInactive(boolean highlight) {
        this.highlightInactive = highlight;
    }

    public void setRenderStackSize(boolean renderStackSize) {
        this.renderStackSize = renderStackSize;
    }

    public void renderWidget(GuiGraphics graphics, int x, int y, float partialTicks) {
        if (this.thisVisible && this.visible && !this.active && this.highlightInactive) {
            graphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + 1, -16711681);
        }
        if (this.thisVisible) {
            super.renderWidget(graphics, x, y, partialTicks);
        }
        if (this.visible) {
            if (this.renderedStacks != null) {
                int startX = this.getIconX();
                for (int i = this.renderedStacks.length - 1; i >= 0; --i) {
                    graphics.renderItem(this.renderedStacks[i], startX + i * this.iconSpacing, this.getY() + 2);
                    if (!this.renderStackSize) continue;
                    graphics.renderItemDecorations(Minecraft.getInstance().font, this.renderedStacks[i], startX + i * this.iconSpacing, this.getY() + 2, null);
                }
            }
            if (this.resLoc != null) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                graphics.blit(this.resLoc, this.getX() + this.width / 2 - 8, this.getY() + 2, 0.0f, 0.0f, 16, 16, 16, 16);
                RenderSystem.disableBlend();
            }
            if (this.active && !this.thisVisible && x >= this.getX() && y >= this.getY() && x < this.getX() + this.width && y < this.getY() + this.height) {
                graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, this.invisibleHoverColor);
            }
            if (this.isHovered && this.tooltipSupplier != null) {
                ArrayList l = new ArrayList();
                this.tooltipSupplier.get().forEach(c -> l.addAll(Tooltip.splitTooltip((Minecraft)Minecraft.getInstance(), (Component)c)));
                graphics.renderTooltip(Minecraft.getInstance().font, l, x, y);
            }
        }
    }

    private int getIconX() {
        return switch (this.iconPosition.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> this.getX() - 1 - 18 * this.renderedStacks.length;
            case 2 -> this.getX() + this.width + 1;
            case 0 -> this.getX() + this.width / 2 - this.renderedStacks.length * 9 + 1;
        };
    }

    public WidgetButtonExtended setTooltipText(Component comp) {
        this.setTooltip(Tooltip.create((Component)comp));
        return this;
    }

    public WidgetButtonExtended setTooltipText(List<Component> comps) {
        this.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.combineComponents(comps)));
        return this;
    }

    public WidgetButtonExtended setTooltipKey(String tip) {
        this.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate(tip, new Object[0])));
        return this;
    }

    public static enum IconPosition {
        MIDDLE,
        LEFT,
        RIGHT;

    }
}

