/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import me.desht.pneumaticcraft.api.registry.PNCRegistries;
import me.desht.pneumaticcraft.api.remote.IRemoteVariableWidget;
import me.desht.pneumaticcraft.api.remote.IRemoteWidget;
import me.desht.pneumaticcraft.api.remote.RemoteWidgetType;
import me.desht.pneumaticcraft.client.gui.remote.AbstractRemoteScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteEditorScreen;
import me.desht.pneumaticcraft.client.gui.remote.config.RemoteButtonOptionScreen;
import me.desht.pneumaticcraft.client.gui.remote.config.RemoteCheckboxOptionScreen;
import me.desht.pneumaticcraft.client.gui.remote.config.RemoteDropdownOptionScreen;
import me.desht.pneumaticcraft.client.gui.remote.config.RemoteLabelOptionScreen;
import me.desht.pneumaticcraft.common.registry.ModRemoteWidgetTypes;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public enum RemoteClientRegistry {
    INSTANCE;

    private final Map<ResourceLocation, Factory<? extends IRemoteWidget, ? extends AbstractWidget>> factoryMap = new ConcurrentHashMap<ResourceLocation, Factory<? extends IRemoteWidget, ? extends AbstractWidget>>();

    public void registerClientFactories() {
        this.register(ModRemoteWidgetTypes.BUTTON.get(), RemoteButtonOptionScreen.Factory.INSTANCE);
        this.register(ModRemoteWidgetTypes.CHECKBOX.get(), RemoteCheckboxOptionScreen.Factory.INSTANCE);
        this.register(ModRemoteWidgetTypes.DROPDOWN.get(), RemoteDropdownOptionScreen.Factory.INSTANCE);
        this.register(ModRemoteWidgetTypes.LABEL.get(), RemoteLabelOptionScreen.Factory.INSTANCE);
    }

    public <RW extends IRemoteWidget> void register(RemoteWidgetType<RW> type, Factory<RW, ? extends AbstractWidget> factory) {
        this.factoryMap.put(PNCRegistries.REMOTE_WIDGETS_REGISTRY.getKey(type), factory);
    }

    public <RW extends IRemoteWidget, MCW extends AbstractWidget> MCW createMinecraftWidget(RW remoteWidget, AbstractRemoteScreen screen) {
        Factory<? extends IRemoteWidget, ? extends AbstractWidget> factory = this.factoryMap.get(RemoteClientRegistry.getKey(remoteWidget));
        return (MCW)factory.createMinecraftWidget(remoteWidget, screen);
    }

    public <RW extends IRemoteWidget, MCW extends AbstractWidget> Screen createConfigurationScreen(RW remoteWidget, RemoteEditorScreen screen) {
        Factory<? extends IRemoteWidget, ? extends AbstractWidget> factory = this.factoryMap.get(RemoteClientRegistry.getKey(remoteWidget));
        return factory.createConfigurationScreen(remoteWidget, screen);
    }

    public <RW extends IRemoteVariableWidget, MCW extends AbstractWidget> void handleGlobalVariableChange(RW remoteWidget, MCW mcWidget, String varName) {
        Factory<? extends IRemoteWidget, ? extends AbstractWidget> factory = this.factoryMap.get(RemoteClientRegistry.getKey(remoteWidget));
        factory.handleGlobalVariableChange(remoteWidget, mcWidget, varName);
    }

    @NotNull
    private static ResourceLocation getKey(IRemoteWidget remoteWidget) {
        return Objects.requireNonNull(PNCRegistries.REMOTE_WIDGETS_REGISTRY.getKey(remoteWidget.getType()));
    }

    public static interface Factory<RW extends IRemoteWidget, MCW extends AbstractWidget> {
        public MCW createMinecraftWidget(RW var1, AbstractRemoteScreen var2);

        public Screen createConfigurationScreen(RW var1, RemoteEditorScreen var2);

        default public void handleGlobalVariableChange(RW remoteWidget, MCW mcWidget, String varName) {
        }
    }
}

