/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.AbstractProgWidgetScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.Util;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class ProgWidgetLiquidFilterScreen
extends AbstractProgWidgetScreen<ProgWidgetLiquidFilter> {
    private static final int GRID_WIDTH = 8;
    private static final int GRID_HEIGHT = 6;
    private WidgetFluidStack mainFilter;
    private WidgetVerticalScrollbar scrollbar;
    private WidgetTextField searchField;
    private int lastScroll;
    private final List<WidgetFluidStack> visibleFluidWidgets = new ArrayList<WidgetFluidStack>();
    private int textTimer = 0;
    private long lastClickTime = 0L;

    public ProgWidgetLiquidFilterScreen(ProgWidgetLiquidFilter widget, ProgrammerScreen guiProgrammer) {
        super(widget, guiProgrammer);
        this.xSize = 176;
        this.ySize = 166;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_ITEM_SEARCHER;
    }

    @Override
    public void init() {
        super.init();
        this.mainFilter = new WidgetFluidStack(this.guiLeft + 148, this.guiTop + 25, ((ProgWidgetLiquidFilter)this.progWidget).getFluidStack().getFluid(), b -> {
            b.setFluid(Fluids.EMPTY);
            ((ProgWidgetLiquidFilter)this.progWidget).setFluidStack(FluidStack.EMPTY);
        });
        this.addRenderableWidget((GuiEventListener)this.mainFilter);
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 8; ++x) {
                WidgetFluidStack f = new WidgetFluidStack(this.guiLeft + 8 + x * 18, this.guiTop + 52 + y * 18, Fluids.EMPTY, this::fluidClicked);
                this.addRenderableWidget((GuiEventListener)f);
                this.visibleFluidWidgets.add(f);
            }
        }
        this.searchField = new WidgetTextField(this.font, this.guiLeft + 8, this.guiTop + 34, 90);
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.setFocused((GuiEventListener)this.searchField);
        this.searchField.setResponder(s -> {
            this.textTimer = 5;
        });
        this.scrollbar = new WidgetVerticalScrollbar(this.guiLeft + 155, this.guiTop + 51, 108);
        this.scrollbar.setListening(true);
        this.addRenderableWidget((GuiEventListener)this.scrollbar);
        this.addValidFluids();
    }

    private void addValidFluids() {
        List<Fluid> fluids = BuiltInRegistries.FLUID.stream().filter(fluid -> this.matchSearch(this.searchField.getValue(), (Fluid)fluid)).sorted(Comparator.comparing(f -> new FluidStack(f, 1).getHoverName().getString())).toList();
        this.scrollbar.setStates(Math.max(0, (fluids.size() - 48 + 8 - 1) / 8));
        int offset = this.scrollbar.getState() * 8;
        for (int i = 0; i < this.visibleFluidWidgets.size(); ++i) {
            if (i + offset < fluids.size()) {
                this.visibleFluidWidgets.get(i).setFluid(fluids.get(i + offset));
                continue;
            }
            this.visibleFluidWidgets.get(i).setFluid(Fluids.EMPTY);
        }
    }

    private void fluidClicked(WidgetFluidStack widget) {
        long now = Util.getMillis();
        if (now - this.lastClickTime < 250L && FluidStack.isSameFluidSameComponents((FluidStack)((ProgWidgetLiquidFilter)this.progWidget).getFluidStack(), (FluidStack)widget.getFluidStack())) {
            this.onClose();
        } else {
            this.mainFilter.setFluid(widget.getFluid());
            ((ProgWidgetLiquidFilter)this.progWidget).setFluidStack(widget.getFluidStack().copy());
        }
        this.lastClickTime = now;
    }

    private boolean matchSearch(String srch, Fluid fluid) {
        if (fluid == Fluids.EMPTY || !fluid.isSource(fluid.defaultFluidState())) {
            return false;
        }
        if (srch.isEmpty()) {
            return true;
        }
        String srchL = srch.toLowerCase();
        if (srchL.startsWith("@")) {
            ResourceLocation id = PneumaticCraftUtils.getRegistryName(fluid).orElse(ResourceLocation.withDefaultNamespace((String)"none"));
            return id.getNamespace().startsWith(srchL.substring(1));
        }
        if (srchL.startsWith("#")) {
            ResourceLocation id = ResourceLocation.tryParse((String)srchL.substring(1));
            return id != null && fluid.builtInRegistryHolder().is(TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)id));
        }
        return new FluidStack(fluid, 1).getHoverName().getString().toLowerCase().contains(srchL);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastScroll != this.scrollbar.getState()) {
            this.lastScroll = this.scrollbar.getState();
            this.addValidFluids();
        } else if (this.textTimer > 0 && --this.textTimer == 0) {
            this.addValidFluids();
        }
    }
}

