/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketProgrammerSync;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class AbstractProgWidgetScreen<P extends IProgWidget>
extends AbstractPneumaticCraftScreen {
    protected final P progWidget;
    protected final ProgrammerScreen guiProgrammer;

    AbstractProgWidgetScreen(P progWidget, ProgrammerScreen guiProgrammer) {
        super((Component)Component.translatable((String)progWidget.getTranslationKey()));
        this.progWidget = progWidget;
        this.guiProgrammer = guiProgrammer;
        this.xSize = 183;
        this.ySize = 202;
    }

    @Override
    public void init() {
        super.init();
        MutableComponent title = PneumaticCraftUtils.xlate(this.progWidget.getTranslationKey(), new Object[0]);
        this.addLabel((Component)title, this.width / 2 - this.font.width((FormattedText)title) / 2, this.guiTop + 5);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)this.guiProgrammer);
    }

    public void removed() {
        if (this.guiProgrammer != null) {
            NetworkHandler.sendToServer(PacketProgrammerSync.forBlockEntity((ProgrammerBlockEntity)this.guiProgrammer.te));
        } else {
            super.removed();
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        if (this.getGuiTexture() == null) {
            GuiUtils.drawScreenWithTitleArea(graphics, this.guiLeft, this.guiTop, this.xSize, this.ySize, -2238534);
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return null;
    }

    public boolean isPauseScreen() {
        return (Boolean)ConfigHelper.client().general.programmerGuiPauses.get();
    }

    public AbstractContainerMenu getProgrammerContainer() {
        return this.guiProgrammer == null ? null : this.guiProgrammer.getMenu();
    }
}

