/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.NullOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoreComponentsHandler;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ArmorMainScreen
extends AbstractPneumaticCraftScreen
implements IGuiScreen {
    private static final ChatFormatting[] TITLE_PREFIX = new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE};
    public static final ItemStack[] ARMOR_STACKS = new ItemStack[]{new ItemStack((ItemLike)ModItems.PNEUMATIC_BOOTS.get()), new ItemStack((ItemLike)ModItems.PNEUMATIC_LEGGINGS.get()), new ItemStack((ItemLike)ModItems.PNEUMATIC_CHESTPLATE.get()), new ItemStack((ItemLike)ModItems.PNEUMATIC_HELMET.get())};
    private static ArmorMainScreen instance;
    private static int pageNumber;
    private final List<UpgradeOption> upgradeOptions = new ArrayList<UpgradeOption>();
    private boolean inInitPhase = true;
    private final UpgradeOption nullOptionsPage = new UpgradeOption(new NullOptions(this), PneumaticRegistry.RL("null"), new ItemStack((ItemLike)Items.BARRIER));

    private ArmorMainScreen() {
        super((Component)Component.literal((String)"Main Screen"));
    }

    public static ArmorMainScreen getInstance() {
        return instance;
    }

    public static void initHelmetCoreComponents() {
        if (instance == null) {
            instance = new ArmorMainScreen();
            Window mw = Minecraft.getInstance().getWindow();
            instance.init(Minecraft.getInstance(), mw.getGuiScaledWidth(), mw.getGuiScaledHeight());
            int i = 1;
            while (i < ArmorMainScreen.instance.upgradeOptions.size()) {
                pageNumber = i++;
                instance.init();
            }
            pageNumber = 0;
            ArmorMainScreen.instance.inInitPhase = false;
            ArmorFeatureStatus.INSTANCE.saveIfChanged();
        }
    }

    @Override
    public void init() {
        super.init();
        this.xSize = this.width;
        this.ySize = this.height;
        this.clearWidgets();
        this.upgradeOptions.clear();
        this.addPages();
        int xPos = 200;
        int yPos = 5;
        int buttonWidth = this.font.width((FormattedText)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.core_components", new Object[0]));
        for (UpgradeOption opt : this.upgradeOptions) {
            buttonWidth = Math.max(buttonWidth, this.font.width((FormattedText)opt.page.getPageName()));
        }
        for (int i = 0; i < this.upgradeOptions.size(); ++i) {
            int idx = i;
            WidgetButtonExtended button = new WidgetButtonExtended(xPos, yPos, buttonWidth + 10, 20, (Component)this.upgradeOptions.get((int)i).page.getPageName(), b -> this.setPage(idx));
            button.setHighlightWhenInactive(true);
            button.setRenderStacks(this.upgradeOptions.get((int)i).icons).setIconPosition(WidgetButtonExtended.IconPosition.RIGHT).setIconSpacing(12);
            if (pageNumber == i) {
                button.active = false;
            }
            this.addRenderableWidget((GuiEventListener)button);
            if ((yPos += 22) <= this.ySize - 22) continue;
            yPos = 5;
            xPos += buttonWidth + 55;
        }
        if ((pageNumber = Math.min(pageNumber, this.upgradeOptions.size() - 1)) < 0 && !this.upgradeOptions.isEmpty()) {
            pageNumber = 0;
        }
        this.maybeAddEnableCheckbox();
        this.maybeAddStatHiddenCheckbox();
        this.getCurrentOptionsPage().page.populateGui(this);
    }

    private void maybeAddEnableCheckbox() {
        ICheckboxWidget checkBox = PneumaticRegistry.getInstance().getClientArmorRegistry().makeKeybindingCheckBox(this.getCurrentOptionsPage().upgradeID, 40, 25, -1, null);
        if (this.getCurrentOptionsPage().page.isToggleable()) {
            this.addRenderableWidget((GuiEventListener)checkBox.asWidget());
        }
    }

    private void maybeAddStatHiddenCheckbox() {
        IArmorUpgradeClientHandler<?> handler = this.getCurrentOptionsPage().page.getClientUpgradeHandler();
        StatPanelLayout layout = ArmorHUDLayout.INSTANCE.getLayoutFor(this.getCurrentOptionsPage().upgradeID, handler.getDefaultStatLayout());
        WidgetCheckBox statToggle = new WidgetCheckBox(40, 37, -1, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.hideStat", new Object[0]), b -> ArmorHUDLayout.INSTANCE.updateLayout(this.getCurrentOptionsPage().upgradeID, layout.x(), layout.y(), layout.expandsLeft(), b.checked));
        if (handler.getAnimatedStat() != null) {
            statToggle.checked = layout.hidden();
            this.addRenderableWidget((GuiEventListener)statToggle);
        }
    }

    private void setPage(int newPage) {
        pageNumber = newPage;
        this.init();
    }

    public UpgradeOption getCurrentOptionsPage() {
        if (pageNumber >= 0 && pageNumber < this.upgradeOptions.size()) {
            return this.upgradeOptions.get(pageNumber);
        }
        return this.nullOptionsPage;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return null;
    }

    private void addPages() {
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            List<IArmorUpgradeHandler<?>> upgradeHandlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
            for (int i = 0; i < upgradeHandlers.size(); ++i) {
                IArmorUpgradeClientHandler<?> clientHandler;
                IOptionPage optionPage;
                if (!this.inInitPhase && !CommonArmorHandler.getHandlerForPlayer().isUpgradeInserted(slot, i) && (slot != EquipmentSlot.HEAD || i != 0)) continue;
                IArmorUpgradeHandler<?> handler = upgradeHandlers.get(i);
                if (!this.inInitPhase && !PneumaticArmorItem.isPneumaticArmorPiece(ClientUtils.getClientPlayer(), slot) && !(handler instanceof CoreComponentsHandler) || (optionPage = (clientHandler = ClientArmorRegistry.getInstance().getClientHandler(handler.getID())).getGuiOptionsPage(this)) == null) continue;
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                stacks.add(ARMOR_STACKS[handler.getEquipmentSlot().getIndex()]);
                Arrays.stream(handler.getRequiredUpgrades()).map(PNCUpgrade::getItemStack).forEach(stacks::add);
                this.upgradeOptions.add(new UpgradeOption(optionPage, handler.getID(), stacks.toArray(new ItemStack[0])));
            }
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(graphics);
    }

    @Override
    protected void drawForeground(GuiGraphics graphics, int x, int y, float partialTicks) {
        IOptionPage optionPage = this.getCurrentOptionsPage().page;
        optionPage.renderPre(graphics, x, y, partialTicks);
        graphics.drawCenteredString(this.font, (Component)optionPage.getPageName().copy().withStyle(TITLE_PREFIX), 100, 12, -1);
        if (optionPage.displaySettingsHeader()) {
            graphics.drawCenteredString(this.font, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.settings", new Object[0]).withStyle(ChatFormatting.DARK_AQUA), 100, optionPage.settingsYposition(), -1);
        }
        optionPage.renderPost(graphics, x, y, partialTicks);
    }

    @Override
    public void tick() {
        super.tick();
        IOptionPage optionPage = this.getCurrentOptionsPage().page;
        optionPage.tick();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.getCurrentOptionsPage().page.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.getCurrentOptionsPage().page.keyReleased(keyCode, scanCode, modifiers) || super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.getCurrentOptionsPage().page.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dirX, double dirY) {
        return this.getCurrentOptionsPage().page.mouseScrolled(mouseX, mouseY, dirX, dirY) || super.mouseScrolled(mouseX, mouseY, dirX, dirY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.getCurrentOptionsPage().page.mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public <T extends AbstractWidget> T addWidget(T w) {
        return (T)((AbstractWidget)this.addRenderableWidget((GuiEventListener)w));
    }

    @Override
    public List<Renderable> getWidgetList() {
        return ImmutableList.copyOf((Collection)this.renderables);
    }

    @Override
    public Font getFontRenderer() {
        return this.font;
    }

    @Override
    public void setFocusedWidget(AbstractWidget w) {
        this.setFocused((GuiEventListener)w);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public record UpgradeOption(IOptionPage page, ResourceLocation upgradeID, ItemStack[] icons) {
    }
}

