/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.PNCForgeSlider;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.UVLightBoxBlock;
import me.desht.pneumaticcraft.common.block.entity.processing.UVLightBoxBlockEntity;
import me.desht.pneumaticcraft.common.inventory.UVLightBoxMenu;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class UVLightBoxScreen
extends AbstractPneumaticCraftContainerScreen<UVLightBoxMenu, UVLightBoxBlockEntity> {
    private PNCForgeSlider slider;

    public UVLightBoxScreen(UVLightBoxMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageHeight = 196;
    }

    @Override
    public void init() {
        super.init();
        this.slider = new PNCForgeSlider(this.leftPos + 10, this.topPos + 45, 95, 16, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.uv_light_box.threshold", new Object[0]).append(" "), (Component)Component.literal((String)"%"), 1.0, 100.0, ((UVLightBoxBlockEntity)this.te).getThreshold(), true, slider -> this.sendDelayed(5));
        this.addRenderableWidget((GuiEventListener)this.slider);
    }

    @Override
    public void containerTick() {
        boolean interpolate;
        boolean bl = interpolate = ((UVLightBoxBlockEntity)this.te).rsController.getCurrentMode() == 3;
        if (this.firstUpdate || interpolate) {
            this.slider.setValue(((UVLightBoxBlockEntity)this.te).getThreshold());
        }
        this.slider.active = !interpolate;
        this.slider.visible = !interpolate || ((UVLightBoxBlockEntity)this.te).getRedstoneController().getCurrentRedstonePower() > 0;
        super.containerTick();
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        BlockState state = ((UVLightBoxBlockEntity)this.te).getBlockState();
        return state.getBlock() == ModBlocks.UV_LIGHT_BOX.get() && (Boolean)state.getValue((Property)UVLightBoxBlock.LIT) != false ? Textures.GUI_UV_LIGHT_BOX_ON : Textures.GUI_UV_LIGHT_BOX;
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.width - this.imageWidth) / 2;
        int yStart = (this.height - this.imageHeight) / 2;
        return new PointXY(xStart + this.imageWidth * 3 / 4 + 10, yStart + this.imageHeight / 4 - 5);
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        if (((UVLightBoxBlockEntity)this.te).getItemHandler().getStackInSlot(0).isEmpty()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.uv_light_box.no_item", new Object[0]));
        }
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        BlockState state = ((UVLightBoxBlockEntity)this.te).getBlockState();
        if (state.getBlock() instanceof UVLightBoxBlock && ((Boolean)state.getValue((Property)UVLightBoxBlock.LIT)).booleanValue()) {
            float usage = 2.0f * ((UVLightBoxBlockEntity)this.te).getSpeedUsageMultiplierFromUpgrades();
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.airUsage", PneumaticCraftUtils.roundNumberTo(usage, 2)));
        }
    }

    @Override
    protected void doDelayedAction() {
        this.sendGUIButtonPacketToServer(Integer.toString(this.slider.getValueInt()));
    }
}

