/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.playerfilter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record DimensionMatcher(List<ResourceLocation> dimensionIds) implements IPlayerMatcher
{
    public static final MapCodec<DimensionMatcher> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ResourceLocation.CODEC.listOf().fieldOf("dimensions").forGetter(DimensionMatcher::dimensionIds)).apply((Applicative)inst, DimensionMatcher::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DimensionMatcher> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), DimensionMatcher::dimensionIds, DimensionMatcher::new);
    public static final IPlayerMatcher.MatcherType<DimensionMatcher> TYPE = new IPlayerMatcher.MatcherType<DimensionMatcher>(CODEC, STREAM_CODEC);

    @Override
    public IPlayerMatcher.MatcherType<? extends IPlayerMatcher> type() {
        return TYPE;
    }

    @Override
    public void addDescription(Player player, List<Component> tooltip) {
        if (!this.dimensionIds.isEmpty()) {
            List<Component> items = this.dimensionIds.stream().map(id -> Component.literal((String)id.toString())).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.dimensions", new Object[0]), items);
        }
    }

    @Override
    public boolean test(Player playerEntity) {
        return this.dimensionIds.isEmpty() || this.dimensionIds.contains(playerEntity.level().dimension().location());
    }
}

