/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.Optional;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.block.entity.tube.AdvancedPressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class ChargingModule
extends AbstractTubeModule {
    private BlockEntity neighbourTE = null;

    public ChargingModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.CHARGING_MODULE.get();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.pressureTube.nonNullLevel().isClientSide || (this.pressureTube.nonNullLevel().getGameTime() & 7L) != 0L) {
            return;
        }
        this.getConnectedInventory().ifPresent(itemHandler -> {
            int advMul = this.pressureTube instanceof AdvancedPressureTubeBlockEntity ? 4 : 1;
            int transferLimit = 80 * (this.upgraded ? 10 : 1) * advMul;
            PNCCapabilities.getAirHandler(this.pressureTube).ifPresent(airHandler -> {
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    ItemStack chargedItem = itemHandler.getStackInSlot(slot);
                    if (chargedItem.getCount() != 1) continue;
                    PNCCapabilities.getAirHandler(chargedItem).ifPresent(airHandlerItem -> {
                        float itemPressure = airHandlerItem.getPressure();
                        float modulePressure = airHandler.getPressure();
                        float delta = Math.abs(modulePressure - itemPressure) / 2.0f;
                        int airInItem = airHandlerItem.getAir();
                        if (itemPressure > modulePressure + 0.01f && itemPressure > 0.0f) {
                            int airToMove = Math.min(Math.min(transferLimit, airInItem), (int)(delta * (float)airHandler.getVolume()));
                            airHandlerItem.addAir(-airToMove);
                            airHandler.addAir(airToMove);
                        } else if (itemPressure < modulePressure - 0.01f && itemPressure < airHandlerItem.maxPressure()) {
                            float itemVolume = airHandlerItem.getVolume();
                            int maxAirInItem = (int)(airHandlerItem.maxPressure() * itemVolume);
                            int airToMove = Math.min(Math.min(transferLimit, airHandler.getAir()), (int)(delta * itemVolume));
                            airToMove = Math.min(maxAirInItem - airInItem, airToMove);
                            airHandlerItem.addAir(airToMove);
                            airHandler.addAir(-airToMove);
                        }
                    });
                }
            });
        });
    }

    private Optional<IItemHandler> getConnectedInventory() {
        if (this.neighbourTE == null || this.neighbourTE.isRemoved()) {
            this.neighbourTE = this.pressureTube.nonNullLevel().getBlockEntity(this.pressureTube.getBlockPos().relative(this.dir));
        }
        return this.neighbourTE == null ? Optional.empty() : IOHelper.getInventoryForBlock(this.neighbourTE, this.dir.getOpposite());
    }
}

