/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei.transfer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.drone.ProgWidgetUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCrafting;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.inventory.ProgrammerMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketProgrammerSync;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.jetbrains.annotations.Nullable;

public class ProgrammerTransferHandler
implements IUniversalRecipeTransferHandler<ProgrammerMenu> {
    private static ProgrammerScreen programmerScreen = null;
    private final IRecipeTransferHandlerHelper transferHelper;

    public ProgrammerTransferHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    public Class<ProgrammerMenu> getContainerClass() {
        return ProgrammerMenu.class;
    }

    public Optional<MenuType<ProgrammerMenu>> getMenuType() {
        return Optional.of(ModMenuTypes.PROGRAMMER.get());
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ProgrammerMenu container, Object recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (programmerScreen != null) {
            IProgWidget craftingWidget;
            List<ProgWidgetItemFilter> params = this.makeFilterWidgets(craftingWidget, recipe, recipeSlots, (craftingWidget = this.findSuitableCraftingWidget(programmerScreen)) == null && !maxTransfer);
            if (params.isEmpty()) {
                return this.transferHelper.createInternalError();
            }
            if (doTransfer) {
                ProgrammerBlockEntity programmer = (ProgrammerBlockEntity)ProgrammerTransferHandler.programmerScreen.te;
                programmer.progWidgets.addAll(params);
                NetworkHandler.sendToServer(PacketProgrammerSync.forBlockEntity(programmer));
                ProgWidgetUtils.updatePuzzleConnections(programmer.progWidgets);
            }
            return null;
        }
        return this.transferHelper.createInternalError();
    }

    private List<ProgWidgetItemFilter> makeFilterWidgets(IProgWidget craftingWidget, Object recipe, IRecipeSlotsView recipeSlotsView, boolean uniqueStacks) {
        PointXY base;
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        HashSet itemsSeen = new HashSet();
        recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT).forEach(view -> view.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).ifPresentOrElse(stack -> {
            l.add(uniqueStacks && itemsSeen.contains(stack.getItem()) ? ItemStack.EMPTY : stack);
            itemsSeen.add(stack.getItem());
        }, () -> l.add(ItemStack.EMPTY)));
        if (recipe instanceof ShapedRecipe) {
            if (l.size() != 9) {
                return Collections.emptyList();
            }
            for (int n = 0; n < 2; ++n) {
                if (!((ItemStack)l.get(0)).isEmpty() || !((ItemStack)l.get(3)).isEmpty() || !((ItemStack)l.get(6)).isEmpty()) continue;
                for (int i = 0; i < l.size(); ++i) {
                    if (i % 3 == 2) {
                        l.set(i, ItemStack.EMPTY);
                        continue;
                    }
                    l.set(i, (ItemStack)l.get(i + 1));
                }
            }
        }
        ProgWidgetItemFilter filterWidget = new ProgWidgetItemFilter();
        if (craftingWidget == null) {
            Rect2i bounds = programmerScreen.getProgrammerBounds();
            base = programmerScreen.mouseToWidgetCoords(programmerScreen.getGuiLeft() + bounds.getX() + 50, programmerScreen.getGuiTop() + bounds.getY() + 50, filterWidget);
        } else {
            base = new PointXY(craftingWidget.getX() + craftingWidget.getWidth() / 2, craftingWidget.getY());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int c = 0;
        for (int n = 0; n < l.size(); ++n) {
            ItemStack stack = (ItemStack)l.get(n);
            if (stack.isEmpty() && (craftingWidget == null || n % 3 >= 2 || ((ItemStack)l.get(n + 1)).isEmpty())) continue;
            ProgWidgetItemFilter w = ProgWidgetItemFilter.withFilter(stack);
            if (craftingWidget == null) {
                w.setPosition(base.x() + c++ * filterWidget.getWidth() / 2, base.y());
            } else {
                w.setPosition(base.x() + n % 3 * filterWidget.getWidth() / 2, base.y() + n / 3 * filterWidget.getHeight() / 2);
            }
            builder.add((Object)w);
        }
        return builder.build();
    }

    private IProgWidget findSuitableCraftingWidget(ProgrammerScreen guiProgrammer) {
        return ((ProgrammerBlockEntity)ProgrammerTransferHandler.programmerScreen.te).progWidgets.stream().filter(w -> w instanceof ProgWidgetCrafting && guiProgrammer.isVisible((IProgWidget)w)).filter(w -> w.getConnectedParameters()[0] == null && w.getConnectedParameters()[1] == null && w.getConnectedParameters()[2] == null).findFirst().orElse(null);
    }

    public static class Listener {
        @SubscribeEvent
        public static void onGuiOpen(ScreenEvent.Opening event) {
            Screen screen;
            if (event.getScreen() instanceof IRecipesGui && (screen = Minecraft.getInstance().screen) instanceof ProgrammerScreen) {
                ProgrammerScreen p;
                programmerScreen = p = (ProgrammerScreen)screen;
            } else if (!(event.getScreen() instanceof IRecipesGui)) {
                programmerScreen = null;
            }
        }
    }
}

