/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class JEIPressureChamberRecipeCategory
extends AbstractPNCCategory<PressureChamberRecipe> {
    private final ITickTimer tickTimer = JEIPlugin.jeiHelpers.getGuiHelper().createTickTimer(60, 60, false);

    JEIPressureChamberRecipeCategory() {
        super(RecipeTypes.PRESSURE_CHAMBER, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pressureChamber", new Object[0]), (IDrawable)JEIPressureChamberRecipeCategory.guiHelper().createDrawable(Textures.GUI_JEI_PRESSURE_CHAMBER, 5, 11, 166, 116), JEIPressureChamberRecipeCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_WALL.get())));
    }

    protected static Optional<PressureChamberRecipe.SlotCycle> getMatchingCycle(PressureChamberRecipe recipe, IFocus<ItemStack> focus) {
        List<List<ItemStack>> slots;
        if (focus == null) {
            return Optional.empty();
        }
        RecipeIngredientRole role = focus.getRole();
        if (role == RecipeIngredientRole.INPUT) {
            slots = recipe.getInputsForDisplay((HolderLookup.Provider)ClientUtils.getClientLevel().registryAccess());
        } else if (role == RecipeIngredientRole.OUTPUT) {
            slots = new ArrayList<List<ItemStack>>(recipe.getResultsForDisplay((HolderLookup.Provider)ClientUtils.getClientLevel().registryAccess()));
        } else {
            return Optional.empty();
        }
        ItemStack needle = (ItemStack)focus.getTypedValue().getIngredient();
        for (int slot = 0; slot < slots.size(); ++slot) {
            List<ItemStack> stacks = slots.get(slot);
            if (stacks.size() <= 1) continue;
            IntArrayList l = new IntArrayList();
            for (int i = 0; i < stacks.size(); ++i) {
                if (!ItemStack.isSameItem((ItemStack)needle, (ItemStack)stacks.get(i))) continue;
                l.add(i);
            }
            IntList matches = IntLists.unmodifiable((IntList)l);
            if (matches.isEmpty()) continue;
            return Optional.of(new PressureChamberRecipe.SlotCycle(new PressureChamberRecipe.RecipeSlot(role == RecipeIngredientRole.INPUT, slot), matches));
        }
        return Optional.empty();
    }

    protected static List<List<ItemStack>> applyOverrides(boolean isInput, List<List<ItemStack>> slotCycles, Map<PressureChamberRecipe.RecipeSlot, IntList> slotCycleOverrides) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < slotCycles.size(); ++i) {
            List<ItemStack> stacks = slotCycles.get(i);
            IntList cycleOverrides = slotCycleOverrides.get(new PressureChamberRecipe.RecipeSlot(isInput, i));
            if (cycleOverrides != null) {
                builder.add((Object)((List)cycleOverrides.intStream().mapToObj(stacks::get).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())));
                continue;
            }
            builder.add(stacks);
        }
        return builder.build();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PressureChamberRecipe recipe, IFocusGroup focuses) {
        IFocus<ItemStack> focus = this.getItemStackFocus(focuses);
        Map overrides = JEIPressureChamberRecipeCategory.getMatchingCycle(recipe, focus).map(recipe::getSyncForDisplay).orElseGet(ImmutableMap::of);
        List<List<ItemStack>> l = recipe.getInputsForDisplay((HolderLookup.Provider)ClientUtils.getClientLevel().registryAccess());
        List<List<ItemStack>> inputs = JEIPressureChamberRecipeCategory.applyOverrides(true, l, overrides);
        for (int i = 0; i < inputs.size(); ++i) {
            int posX = 19 + i % 3 * 17;
            int posY = 79 - i / 3 * 17;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, posX, posY).setSlotName("in" + i).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputs.get(i))).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)new Tooltip(recipe));
        }
        List<List<ItemStack>> outputs = JEIPressureChamberRecipeCategory.applyOverrides(false, recipe.getResultsForDisplay((HolderLookup.Provider)ClientUtils.getClientLevel().registryAccess()), overrides);
        for (int i = 0; i < outputs.size(); ++i) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 101 + i % 3 * 18, 59 + i / 3 * 18).setSlotName("out" + i).addItemStacks(outputs.get(i))).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)new Tooltip(recipe));
        }
    }

    private IFocus<ItemStack> getItemStackFocus(IFocusGroup focuses) {
        return focuses.getFocuses(RecipeIngredientRole.INPUT).filter(f -> f.getTypedValue().getIngredient() instanceof ItemStack).findFirst().orElse(null);
    }

    public void draw(PressureChamberRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        float pressure = recipe.getCraftingPressureForDisplay() * ((float)this.tickTimer.getValue() / (float)this.tickTimer.getMaxValue());
        PressureGaugeRenderer2D.drawPressureGauge(graphics, Minecraft.getInstance().font, -1.0f, 7.0f, 5.0f, recipe.getCraftingPressureForDisplay(), pressure, 130, 27);
    }

    public void getTooltip(ITooltipBuilder tooltip, PressureChamberRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        tooltip.addAll(this.positionalTooltip(mouseX, mouseY, (x, y) -> x >= 100.0 && y >= 7.0 && x <= 140.0 && y <= 47.0, "pneumaticcraft.gui.tooltip.pressure", Float.valueOf(recipe.getCraftingPressureForDisplay())));
    }

    private record Tooltip(PressureChamberRecipe recipe) implements IRecipeSlotRichTooltipCallback
    {
        public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
            String tooltipKey = this.recipe.getTooltipKey(recipeSlotView.getRole() == RecipeIngredientRole.INPUT, recipeSlotView.getSlotName().orElse(""));
            if (!tooltipKey.isEmpty()) {
                tooltip.addAll(PneumaticCraftUtils.splitStringComponent(I18n.get((String)tooltipKey, (Object[])new Object[0])));
            }
        }
    }
}

