/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUpdateArmorExtraData(EquipmentSlot slot, ResourceLocation upgradeID, DataComponentPatch patch) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUpdateArmorExtraData> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("update_armor_extradata"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateArmorExtraData> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(EquipmentSlot.class), PacketUpdateArmorExtraData::slot, (StreamCodec)ResourceLocation.STREAM_CODEC, PacketUpdateArmorExtraData::upgradeID, (StreamCodec)DataComponentPatch.STREAM_CODEC, PacketUpdateArmorExtraData::patch, PacketUpdateArmorExtraData::new);
    private static final Map<EquipmentSlot, Set<DataComponentType<?>>> VALID_KEYS = (Map)Util.make(new EnumMap(EquipmentSlot.class), map -> {
        PacketUpdateArmorExtraData.addKey(map, EquipmentSlot.HEAD, ModDataComponents.ENTITY_FILTER.get());
        PacketUpdateArmorExtraData.addKey(map, EquipmentSlot.HEAD, ModDataComponents.COORD_TRACKER.get());
        PacketUpdateArmorExtraData.addKey(map, EquipmentSlot.LEGS, ModDataComponents.SPEED_BOOST_PCT.get());
        PacketUpdateArmorExtraData.addKey(map, EquipmentSlot.LEGS, ModDataComponents.JUMP_BOOST_PCT.get());
        PacketUpdateArmorExtraData.addKey(map, EquipmentSlot.FEET, ModDataComponents.JET_BOOTS_PCT.get());
        PacketUpdateArmorExtraData.addKey(map, EquipmentSlot.FEET, ModDataComponents.JET_BOOTS_STABILIZERS.get());
        PacketUpdateArmorExtraData.addKey(map, EquipmentSlot.FEET, ModDataComponents.JET_BOOTS_BUILDER_MODE.get());
        PacketUpdateArmorExtraData.addKey(map, EquipmentSlot.FEET, ModDataComponents.JET_BOOTS_HOVER.get());
        PacketUpdateArmorExtraData.addKey(map, EquipmentSlot.FEET, ModDataComponents.JET_BOOTS_SMART_HOVER.get());
    });

    public static <T> void sendToServer(IArmorUpgradeHandler<?> handler, DataComponentType<T> type, T data) {
        DataComponentPatch patch = DataComponentPatch.builder().set(type, data).build();
        NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(handler.getEquipmentSlot(), handler.getID(), patch));
    }

    private static void addKey(Map<EquipmentSlot, Set<DataComponentType<?>>> map, EquipmentSlot slot, DataComponentType<?> type) {
        map.computeIfAbsent(slot, k -> new HashSet()).add(type);
    }

    public CustomPacketPayload.Type<PacketUpdateArmorExtraData> type() {
        return TYPE;
    }

    public static void handle(PacketUpdateArmorExtraData message, IPayloadContext ctx) {
        DataComponentMap dataComponentMap;
        ItemStack stack = ctx.player().getItemBySlot(message.slot());
        if (stack.getItem() instanceof PneumaticArmorItem && (dataComponentMap = stack.getComponents()) instanceof PatchedDataComponentMap) {
            PatchedDataComponentMap pdcm = (PatchedDataComponentMap)dataComponentMap;
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(ctx.player());
            message.patch.entrySet().forEach(entry -> {
                if (PacketUpdateArmorExtraData.isTypeOKForSlot(message.slot, (DataComponentType)entry.getKey())) {
                    pdcm.applyPatch(message.patch);
                    IArmorUpgradeHandler<?> upgradeHandler = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(message.upgradeID());
                    if (upgradeHandler != null) {
                        upgradeHandler.onDataFieldUpdated(handler, (DataComponentType)entry.getKey(), ((Optional)entry.getValue()).orElse(null));
                    }
                }
            });
        }
    }

    private static boolean isTypeOKForSlot(EquipmentSlot slot, DataComponentType<?> type) {
        return VALID_KEYS.get(slot).contains(type);
    }
}

