/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketToggleArmorFeatureBulk(List<PacketToggleArmorFeature.FeatureSetting> features) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketToggleArmorFeatureBulk> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("toggle_armor_feature_bulk"));
    public static final StreamCodec<FriendlyByteBuf, PacketToggleArmorFeatureBulk> STREAM_CODEC = StreamCodec.composite((StreamCodec)PacketToggleArmorFeature.FeatureSetting.STREAM_CODEC.apply(ByteBufCodecs.list()), PacketToggleArmorFeatureBulk::features, PacketToggleArmorFeatureBulk::new);

    public CustomPacketPayload.Type<PacketToggleArmorFeatureBulk> type() {
        return TYPE;
    }

    public static void handle(PacketToggleArmorFeatureBulk message, IPayloadContext ctx) {
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(ctx.player());
        message.features().forEach(feature -> {
            if (feature.featureIndex() >= 0 && feature.featureIndex() < ArmorUpgradeRegistry.getInstance().getHandlersForSlot(feature.slot()).size() && PneumaticArmorItem.isPneumaticArmorPiece(ctx.player(), feature.slot())) {
                handler.setUpgradeEnabled(feature.slot(), feature.featureIndex(), feature.state());
            }
        });
    }
}

