/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketShiftScrollWheel(boolean forward, InteractionHand hand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketShiftScrollWheel> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("shift_scroll_wheel"));
    public static final StreamCodec<FriendlyByteBuf, PacketShiftScrollWheel> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, PacketShiftScrollWheel::forward, (StreamCodec)NeoForgeStreamCodecs.enumCodec(InteractionHand.class), PacketShiftScrollWheel::hand, PacketShiftScrollWheel::new);

    public CustomPacketPayload.Type<PacketShiftScrollWheel> type() {
        return TYPE;
    }

    public static void handle(PacketShiftScrollWheel message, IPayloadContext ctx) {
        Item item = ctx.player().getItemInHand(message.hand()).getItem();
        if (item instanceof IShiftScrollable) {
            IShiftScrollable ss = (IShiftScrollable)item;
            ss.onShiftScrolled(ctx.player(), message.forward(), message.hand());
        }
    }
}

