/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker.TrackerBlacklistManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketSendNBTPacket(BlockPos pos, CompoundTag tag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSendNBTPacket> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("send_nbt_packet"));
    public static final StreamCodec<FriendlyByteBuf, PacketSendNBTPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketSendNBTPacket::pos, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, PacketSendNBTPacket::tag, PacketSendNBTPacket::new);

    public static PacketSendNBTPacket forBlockEntity(BlockEntity te) {
        return new PacketSendNBTPacket(te.getBlockPos(), te.saveCustomOnly((HolderLookup.Provider)te.getLevel().registryAccess()));
    }

    public static PacketSendNBTPacket fromNetwork(FriendlyByteBuf buffer) {
        return new PacketSendNBTPacket(buffer.readBlockPos(), buffer.readNbt());
    }

    public CustomPacketPayload.Type<PacketSendNBTPacket> type() {
        return TYPE;
    }

    public static void handle(PacketSendNBTPacket message, IPayloadContext ctx) {
        BlockEntity te = ctx.player().level().getBlockEntity(message.pos());
        if (te != null) {
            try {
                te.loadCustomOnly(message.tag(), (HolderLookup.Provider)ctx.player().registryAccess());
            }
            catch (Throwable e) {
                TrackerBlacklistManager.addInventoryTEToBlacklist(te, e);
            }
        }
    }
}

