/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.datafixers.util.Either;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketModWrenchBlock(BlockPos pos, InteractionHand hand, Either<Direction, Integer> context) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketModWrenchBlock> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("mod_wrench_block"));
    public static final StreamCodec<FriendlyByteBuf, PacketModWrenchBlock> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketModWrenchBlock::pos, (StreamCodec)NeoForgeStreamCodecs.enumCodec(InteractionHand.class), PacketModWrenchBlock::hand, (StreamCodec)ByteBufCodecs.either((StreamCodec)Direction.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT), PacketModWrenchBlock::context, PacketModWrenchBlock::new);

    public static PacketModWrenchBlock forSide(BlockPos pos, InteractionHand hand, Direction side) {
        return new PacketModWrenchBlock(pos, hand, (Either<Direction, Integer>)Either.left((Object)side));
    }

    public static PacketModWrenchBlock forEntity(BlockPos pos, InteractionHand hand, int entityID) {
        return new PacketModWrenchBlock(pos, hand, (Either<Direction, Integer>)Either.right((Object)entityID));
    }

    public CustomPacketPayload.Type<PacketModWrenchBlock> type() {
        return TYPE;
    }

    public static void handle(PacketModWrenchBlock message, IPayloadContext ctx) {
        BlockPos pos;
        Player player = ctx.player();
        Level level = player.level();
        if (level.isAreaLoaded(pos = message.pos(), 0) && PneumaticCraftUtils.canPlayerReach(player, pos)) {
            InteractionHand hand = message.hand();
            if (ModdedWrenchUtils.getInstance().isModdedWrench(player.getItemInHand(hand))) {
                message.context().ifLeft(side -> {
                    BlockState state = level.getBlockState(pos);
                    Block patt0$temp = state.getBlock();
                    if (patt0$temp instanceof IPneumaticWrenchable) {
                        IPneumaticWrenchable wrenchable = (IPneumaticWrenchable)patt0$temp;
                        wrenchable.onWrenched(level, player, pos, (Direction)side, hand);
                    }
                }).ifRight(entityId -> {
                    Entity e = level.getEntity(entityId.intValue());
                    if (e instanceof IPneumaticWrenchable) {
                        IPneumaticWrenchable wrenchable = (IPneumaticWrenchable)e;
                        if (e.isAlive()) {
                            wrenchable.onWrenched(level, player, pos, null, hand);
                        }
                    }
                });
            }
        }
    }
}

