/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourCustomTransition;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourFurnace;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourHeatFrame;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public enum HeatBehaviourManager {
    INSTANCE;

    private final Map<ResourceLocation, Supplier<? extends HeatBehaviour>> behaviourRegistry = new ConcurrentHashMap<ResourceLocation, Supplier<? extends HeatBehaviour>>();

    public static HeatBehaviourManager getInstance() {
        return INSTANCE;
    }

    public void registerDefaultBehaviours() {
        this.registerBehaviour(HeatBehaviourFurnace.ID, HeatBehaviourFurnace::new);
        this.registerBehaviour(HeatBehaviourHeatFrame.ID, HeatBehaviourHeatFrame::new);
        this.registerBehaviour(HeatBehaviourCustomTransition.ID, HeatBehaviourCustomTransition::new);
    }

    public void registerBehaviour(ResourceLocation id, Supplier<? extends HeatBehaviour> behaviour) {
        Objects.requireNonNull(behaviour);
        Supplier<? extends HeatBehaviour> existing = this.behaviourRegistry.put(id, behaviour);
        if (existing != null) {
            Log.warning("Overriding heat behaviour " + String.valueOf(id), new Object[0]);
        }
    }

    public <T extends HeatBehaviour> T createBehaviour(ResourceLocation id) {
        Supplier<? extends HeatBehaviour> behaviour = this.behaviourRegistry.get(id);
        if (behaviour != null) {
            return (T)behaviour.get();
        }
        Log.warning("No heat behaviour found for id: " + String.valueOf(id), new Object[0]);
        return null;
    }

    public int addHeatBehaviours(Level world, BlockPos pos, Direction direction, BiPredicate<LevelAccessor, BlockPos> blockFilter, IHeatExchangerLogic logic, List<HeatBehaviour> list) {
        if (!blockFilter.test((LevelAccessor)world, pos)) {
            return 0;
        }
        int s = list.size();
        for (Supplier<? extends HeatBehaviour> bSup : this.behaviourRegistry.values()) {
            HeatBehaviour behaviour = bSup.get().initialize(logic, world, pos, direction);
            if (!behaviour.isApplicable()) continue;
            list.add(behaviour);
        }
        return list.size() - s;
    }
}

