/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicConstant;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class HeatExchangerLogicAmbient
extends HeatExchangerLogicConstant {
    static final double BASE_AMBIENT_TEMP = 300.0;
    private static final HeatExchangerLogicAmbient DEFAULT_AIR_EXCHANGER = new HeatExchangerLogicAmbient(300.0);
    private static final Int2ObjectOpenHashMap<HeatExchangerLogicAmbient> exchangers = new Int2ObjectOpenHashMap();

    public static HeatExchangerLogicAmbient atPosition(LevelAccessor world, BlockPos pos) {
        if ((Double)ConfigHelper.common().heat.ambientTemperatureBiomeModifier.get() == 0.0 && (Double)ConfigHelper.common().heat.ambientTemperatureHeightModifier.get() == 0.0) {
            return DEFAULT_AIR_EXCHANGER;
        }
        float t = ((Biome)world.getBiome(pos).value()).getBaseTemperature() - 0.8f;
        int h = world.getSeaLevel() - pos.getY();
        double temp = 300.0 + (Double)ConfigHelper.common().heat.ambientTemperatureBiomeModifier.get() * (double)t + (Double)ConfigHelper.common().heat.ambientTemperatureHeightModifier.get() * (double)h;
        return (HeatExchangerLogicAmbient)exchangers.computeIfAbsent((int)temp, HeatExchangerLogicAmbient::new);
    }

    public static double getAmbientTemperature(LevelAccessor world, BlockPos pos) {
        return HeatExchangerLogicAmbient.atPosition(world, pos).getAmbientTemperature();
    }

    private HeatExchangerLogicAmbient(double temperature) {
        super(temperature, (Double)ConfigHelper.common().heat.airThermalResistance.get());
    }
}

