/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.block;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableBlock;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.mixin.accessors.BaseSpawnerAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class HackableMobSpawner
implements IHackableBlock {
    private static final ResourceLocation ID = PneumaticRegistry.RL("mob_spawner");

    @Override
    public ResourceLocation getHackableId() {
        return ID;
    }

    @Override
    public boolean canHack(BlockGetter level, BlockPos pos, BlockState state, Player player) {
        return !HackableMobSpawner.isHacked(level, pos);
    }

    public static boolean isHacked(BlockGetter world, BlockPos pos) {
        SpawnerBlockEntity sbe;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity instanceof SpawnerBlockEntity && ((BaseSpawnerAccess)(sbe = (SpawnerBlockEntity)blockEntity).getSpawner()).getRequiredPlayerRange() == 0;
    }

    @Override
    public void addInfo(BlockGetter world, BlockPos pos, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.neutralize", new Object[0]));
    }

    @Override
    public void addPostHackInfo(BlockGetter world, BlockPos pos, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.neutralized", new Object[0]));
    }

    @Override
    public int getHackTime(BlockGetter world, BlockPos pos, Player player) {
        return 200;
    }

    @Override
    public void onHackComplete(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity sbe = (SpawnerBlockEntity)blockEntity;
            ((BaseSpawnerAccess)sbe.getSpawner()).setRequiredPlayerRange(0);
            BlockState state = world.getBlockState(pos);
            world.sendBlockUpdated(pos, state, state, 3);
        }
    }

    @Override
    public boolean afterHackTick(BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity sbe = (SpawnerBlockEntity)blockEntity;
            BaseSpawner spawner = sbe.getSpawner();
            ((BaseSpawnerAccess)spawner).setOSpin(((BaseSpawnerAccess)spawner).getSpin());
            ((BaseSpawnerAccess)spawner).setSpawnDelay(10);
        }
        return false;
    }
}

