/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import me.desht.pneumaticcraft.common.fluid.PNCFluidRenderProps;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public abstract class FluidOil {
    public static final PNCFluidRenderProps RENDER_PROPS = PNCFluidRenderProps.texture("oil");

    private static BaseFlowingFluid.Properties props() {
        return new BaseFlowingFluid.Properties(ModFluids.OIL_FLUID_TYPE, ModFluids.OIL, ModFluids.OIL_FLOWING).block(ModBlocks.OIL).bucket(ModItems.OIL_BUCKET).tickRate(20);
    }

    public static class Flowing
    extends BaseFlowingFluid.Flowing {
        public Flowing() {
            super(FluidOil.props());
        }
    }

    public static class Source
    extends BaseFlowingFluid.Source {
        public Source() {
            super(FluidOil.props());
        }

        public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
            double y = entity.getY();
            boolean falling = entity.getDeltaMovement().y <= 0.0;
            entity.moveRelative(0.02f, movementVector);
            entity.move(MoverType.SELF, entity.getDeltaMovement());
            if (entity.getFluidTypeHeight(this.getFluidType()) <= entity.getFluidJumpThreshold()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.5, 0.8, 0.5));
                Vec3 fallingMovement = entity.getFluidFallingAdjustedMovement(gravity, falling, entity.getDeltaMovement());
                entity.setDeltaMovement(fallingMovement);
            } else {
                entity.setDeltaMovement(entity.getDeltaMovement().scale(0.5));
            }
            if (!entity.isNoGravity()) {
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, -gravity / 4.0, 0.0));
            }
            Vec3 delta = entity.getDeltaMovement();
            if (entity.horizontalCollision && entity.isFree(delta.x, delta.y + (double)0.6f - entity.getY() + y, delta.z)) {
                entity.setDeltaMovement(delta.x, 0.3, delta.z);
            }
            return true;
        }
    }
}

