/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetConditionBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class ProgWidgetItemCondition
extends ProgWidgetConditionBase {
    public static final MapCodec<ProgWidgetItemCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetItemCondition.baseParts(builder).apply((Applicative)builder, ProgWidgetItemCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetItemCondition> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetItemCondition::new);

    public ProgWidgetItemCondition(ProgWidget.PositionFields pos) {
        super(pos);
    }

    public ProgWidgetItemCondition() {
        super(ProgWidget.PositionFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetItemCondition(this.getPosition());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.CONDITION_ITEM.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.ITEM_FILTER.get(), ModProgWidgetTypes.ITEM_FILTER.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null && this.getConnectedParameters()[3] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.conditionItem.error.noCheckingItem", new Object[0]));
        }
        if (this.getConnectedParameters()[1] == null && this.getConnectedParameters()[4] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.conditionItem.error.noFilter", new Object[0]));
        }
    }

    @Override
    public boolean evaluate(IDrone drone, IProgWidget widget) {
        ProgWidgetItemFilter checkedFilter = (ProgWidgetItemFilter)widget.getConnectedParameters()[0];
        while (checkedFilter != null) {
            if (!ProgWidgetItemFilter.isItemValidForFilters(checkedFilter.getFilter(), ProgWidgetItemCondition.getConnectedWidgetList(this, 1, ModProgWidgetTypes.ITEM_FILTER.get()), ProgWidgetItemCondition.getConnectedWidgetList(this, this.getParameters().size() + 1, ModProgWidgetTypes.ITEM_FILTER.get()), null)) {
                return false;
            }
            checkedFilter = (ProgWidgetItemFilter)checkedFilter.getConnectedParameters()[0];
        }
        checkedFilter = (ProgWidgetItemFilter)widget.getConnectedParameters()[3];
        while (checkedFilter != null) {
            if (ProgWidgetItemFilter.isItemValidForFilters(checkedFilter.getFilter(), ProgWidgetItemCondition.getConnectedWidgetList(this, 1, ModProgWidgetTypes.ITEM_FILTER.get()), ProgWidgetItemCondition.getConnectedWidgetList(this, this.getParameters().size() + 1, ModProgWidgetTypes.ITEM_FILTER.get()), null)) {
                return false;
            }
            checkedFilter = (ProgWidgetItemFilter)checkedFilter.getConnectedParameters()[0];
        }
        return true;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_ITEM;
    }
}

