/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneEntityAIInventoryExport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetInventoryExport
extends ProgWidgetInventoryBase {
    public static final MapCodec<ProgWidgetInventoryExport> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetInventoryExport.invParts(builder).apply((Applicative)builder, ProgWidgetInventoryExport::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetInventoryExport> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, ProgWidgetInventoryExport::new);

    public ProgWidgetInventoryExport(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields invBaseFields) {
        super(pos, invBaseFields);
    }

    public ProgWidgetInventoryExport() {
        super(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetInventoryExport(this.getPosition(), this.invBaseFields().copy());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_INV_EX;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.INVENTORY_EXPORT.get();
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneEntityAIInventoryExport(drone, (ProgWidgetInventoryBase)widget);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.ORANGE;
    }
}

