/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import java.util.Objects;
import me.desht.pneumaticcraft.common.util.CodecUtil;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;

public class AxisOptions {
    public static final Codec<AxisOptions> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtil.bitSetCodec(3).fieldOf("axes").forGetter(a -> a.options)).apply((Applicative)builder, AxisOptions::new));
    public static final StreamCodec<ByteBuf, AxisOptions> STREAM_CODEC = StreamCodec.composite(CodecUtil.bitSetStreamCodec(3), a -> a.options, AxisOptions::new);
    public static final AxisOptions TRUE = new AxisOptions(true, true, true);
    private final BitSet options;

    private AxisOptions(BitSet options) {
        this.options = options;
    }

    public AxisOptions(boolean x, boolean y, boolean z) {
        this.options = new BitSet(3);
        this.options.set(0, x);
        this.options.set(1, y);
        this.options.set(2, z);
    }

    public boolean shouldCheck(Direction.Axis axis) {
        return this.options.get(axis.ordinal());
    }

    public void setCheck(Direction.Axis axis, boolean check) {
        this.options.set(axis.ordinal(), check);
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.putBoolean("checkX", this.shouldCheck(Direction.Axis.X));
        nbt.putBoolean("checkY", this.shouldCheck(Direction.Axis.Y));
        nbt.putBoolean("checkZ", this.shouldCheck(Direction.Axis.Z));
    }

    public void readFromNBT(CompoundTag nbt, boolean def) {
        this.setCheck(Direction.Axis.X, nbt.contains("checkX") ? nbt.getBoolean("checkX") : def);
        this.setCheck(Direction.Axis.Y, nbt.contains("checkY") ? nbt.getBoolean("checkY") : def);
        this.setCheck(Direction.Axis.Z, nbt.contains("checkZ") ? nbt.getBoolean("checkZ") : def);
    }

    public AxisOptions copy() {
        return new AxisOptions(BitSet.valueOf(this.options.toByteArray()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AxisOptions that = (AxisOptions)o;
        return Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hashCode(this.options);
    }
}

