/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.spawning;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.EmptySpawnerBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.inventory.SpawnerExtractorMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.mixin.accessors.BaseSpawnerAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class SpawnerExtractorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
MenuProvider,
IOwnedSpawner {
    private static final int MAX_ENTITY_RANGE = 6;
    private Entity cachedEntity;
    @DescSynced
    private Mode mode = Mode.INIT;
    @DescSynced
    private float targetSpeed;
    private float rotationDegrees;
    private float prevRotationDegrees;
    @GuiSynced
    private float progress;
    private float currentSpeed;
    private int spawnFailures;

    public SpawnerExtractorBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.SPAWNER_EXTRACTOR.get(), pos, state, PressureTier.TIER_ONE, 4000, 4);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        if (Math.abs(this.currentSpeed - this.targetSpeed) < 0.015f) {
            this.currentSpeed = this.targetSpeed;
        } else if (this.currentSpeed < this.targetSpeed) {
            this.currentSpeed += Math.max(0.005f, (this.targetSpeed - this.currentSpeed) / 20.0f);
        } else if (this.currentSpeed > this.targetSpeed) {
            this.currentSpeed -= Math.max(0.01f, (this.targetSpeed - this.currentSpeed) / 10.0f);
        }
        if (this.mode == Mode.INIT) {
            this.updateMode();
        }
        switch (this.mode.ordinal()) {
            case 1: {
                float incr = this.currentSpeed / 1200.0f;
                this.progress = Math.min(1.0f, this.progress + incr);
                break;
            }
            case 2: {
                this.progress = 1.0f;
                this.targetSpeed = 0.0f;
                this.rotationDegrees = this.prevRotationDegrees;
            }
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        this.prevRotationDegrees = this.rotationDegrees;
        this.rotationDegrees += this.currentSpeed * 18.0f;
    }

    @Override
    public void tickServer() {
        int defenderChance;
        super.tickServer();
        int n = defenderChance = this.nonNullLevel().getDifficulty() == Difficulty.EASY ? 40 : 20;
        if (this.mode == Mode.RUNNING && this.getPressure() <= this.getMinWorkingPressure()) {
            this.addAir(1);
            if (this.progress >= 1.0f) {
                this.extractSpawnerCore();
            } else if (this.currentSpeed > 0.1f && this.nonNullLevel().random.nextInt(defenderChance) == 0) {
                this.nonNullLevel().getBlockEntity(this.worldPosition.below(), BlockEntityType.MOB_SPAWNER).ifPresent(te -> {
                    if (!this.trySpawnDefender((SpawnerBlockEntity)te)) {
                        ++this.spawnFailures;
                    }
                });
            }
        }
        if ((this.nonNullLevel().getGameTime() & 0xFL) == 3L) {
            this.targetSpeed = this.getTargetSpeed();
        }
        if ((this.nonNullLevel().getGameTime() & 0x3FL) == 3L) {
            this.spawnFailures = Math.max(0, this.spawnFailures - 1);
        }
    }

    private boolean trySpawnDefender(SpawnerBlockEntity te) {
        double z;
        BaseSpawner spawner = te.getSpawner();
        int spawnRange = 4;
        int maxNearbyEntities = 16;
        CompoundTag nbt = ((BaseSpawnerAccess)spawner).getNextSpawnData().getEntityToSpawn();
        Optional optional = EntityType.by((CompoundTag)nbt);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos pos = te.getBlockPos();
        ListTag listnbt = nbt.getList("Pos", 6);
        int size = listnbt.size();
        Level level = this.nonNullLevel();
        double x = size >= 1 ? listnbt.getDouble(0) : (double)pos.getX() + (level.random.nextDouble() - level.random.nextDouble()) * (double)spawnRange + 0.5;
        double y = size >= 2 ? listnbt.getDouble(1) : (double)(pos.getY() + level.random.nextInt(3) - 1);
        double d = z = size >= 3 ? listnbt.getDouble(2) : (double)pos.getZ() + (level.random.nextDouble() - level.random.nextDouble()) * (double)spawnRange + 0.5;
        if (level.noCollision(((EntityType)optional.get()).getSpawnAABB(x, y, z))) {
            ServerLevel serverworld = (ServerLevel)level;
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)level, e1 -> {
                e1.moveTo(x, y, z, e1.getYRot(), e1.getXRot());
                return e1;
            });
            if (entity == null) {
                return false;
            }
            int entityCount = level.getEntitiesOfClass(entity.getClass(), new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate((double)spawnRange)).size();
            if (entityCount >= maxNearbyEntities) {
                return false;
            }
            entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), level.random.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                Mob mobentity = (Mob)entity;
                if (nbt.size() == 1 && nbt.contains("id", 8)) {
                    EventHooks.finalizeMobSpawnSpawner((Mob)mobentity, (ServerLevelAccessor)serverworld, (DifficultyInstance)serverworld.getCurrentDifficultyAt(this.getPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, (IOwnedSpawner)this, (boolean)true);
                    if (level.getDifficulty() == Difficulty.HARD) {
                        this.getRandomEffects(level.random).forEach(effect -> mobentity.addEffect(new MobEffectInstance(effect, Integer.MAX_VALUE, 2)));
                    }
                }
            }
            if (!serverworld.tryAddFreshEntityWithPassengers(entity)) {
                return false;
            }
            level.levelEvent(2004, pos, 0);
            if (entity instanceof Mob) {
                ((Mob)entity).spawnAnim();
            }
        }
        return true;
    }

    private List<Holder<MobEffect>> getRandomEffects(RandomSource rand) {
        ArrayList<Holder<MobEffect>> l = new ArrayList<Holder<MobEffect>>();
        int n = rand.nextInt(100);
        if (n > 50) {
            l.add(MobEffects.FIRE_RESISTANCE);
        }
        if (n > 75) {
            l.add(MobEffects.MOVEMENT_SPEED);
        }
        if (n > 82) {
            l.add(MobEffects.DAMAGE_BOOST);
        }
        if (n > 92) {
            l.add(MobEffects.REGENERATION);
        }
        if (n > 96) {
            l.add((Holder<MobEffect>)MobEffects.INVISIBILITY);
        }
        return l;
    }

    private void extractSpawnerCore() {
        this.nonNullLevel().getBlockEntity(this.worldPosition.below(), BlockEntityType.MOB_SPAWNER).ifPresent(te -> {
            ItemStack spawnerCore = new ItemStack((ItemLike)ModItems.SPAWNER_CORE.get());
            IItemRegistry reg = PneumaticRegistry.getInstance().getItemRegistry();
            ISpawnerCoreStats stats = reg.getSpawnerCoreStats(spawnerCore);
            Entity e = this.getCachedEntity((SpawnerBlockEntity)te);
            if (e != null && stats != null) {
                stats.addAmount(e.getType(), 100).save(spawnerCore);
                Level level = this.nonNullLevel();
                ItemEntity item = new ItemEntity(level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5, spawnerCore);
                level.addFreshEntity((Entity)item);
                level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 0.5f);
                level.setBlock(this.worldPosition.below(), ((EmptySpawnerBlock)ModBlocks.EMPTY_SPAWNER.get()).defaultBlockState(), 3);
                level.levelEvent(2001, this.worldPosition, Block.getId((BlockState)Blocks.SPAWNER.defaultBlockState()));
            }
        });
    }

    private float getTargetSpeed() {
        if (this.getPressure() > this.getMinWorkingPressure()) {
            return 0.0f;
        }
        return this.nonNullLevel().getBlockEntity(this.worldPosition.below(), BlockEntityType.MOB_SPAWNER).map(spawner -> {
            int players = 0;
            int matches = 0;
            Entity e0 = this.getCachedEntity((SpawnerBlockEntity)spawner);
            if (e0 == null) {
                return Float.valueOf(0.0f);
            }
            List l = this.nonNullLevel().getEntitiesOfClass(LivingEntity.class, new AABB(this.worldPosition).inflate(6.0), e -> true);
            for (LivingEntity e2 : l) {
                if (e2 instanceof Player && !(e2 instanceof FakePlayer)) {
                    ++players;
                }
                if (e2.getType() != e0.getType()) continue;
                ++matches;
            }
            int n = players > 0 ? Math.min(10, matches + this.spawnFailures) : 10;
            return Float.valueOf(1.0f - (float)n / 10.0f);
        }).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Entity getCachedEntity(SpawnerBlockEntity spawner) {
        if (this.cachedEntity == null) {
            this.cachedEntity = EntityType.loadEntityRecursive((CompoundTag)((BaseSpawnerAccess)spawner.getSpawner()).getNextSpawnData().getEntityToSpawn(), (Level)this.nonNullLevel(), Function.identity());
        }
        return this.cachedEntity;
    }

    public float getRotationDegrees() {
        return this.rotationDegrees;
    }

    public float getPrevRotationDegrees() {
        return this.prevRotationDegrees;
    }

    public float getProgress() {
        return this.progress;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putFloat("progress", this.progress);
        tag.putByte("mode", (byte)this.mode.ordinal());
        tag.putFloat("targetSpeed", this.targetSpeed);
        tag.putInt("spawnFailures", this.spawnFailures);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.progress = tag.getFloat("progress");
        this.mode = Mode.values()[tag.getByte("mode")];
        this.targetSpeed = tag.getFloat("targetSpeed");
        this.spawnFailures = tag.getInt("spawnFailures");
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side.getAxis().isHorizontal();
    }

    @Override
    public float getMinWorkingPressure() {
        return this.mode == Mode.RUNNING ? -0.5f : 0.0f;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new SpawnerExtractorMenu(windowId, inv, this.worldPosition);
    }

    public Either<BlockEntity, Entity> getOwner() {
        return Either.left((Object)this);
    }

    public void updateMode() {
        BlockState below = this.nonNullLevel().getBlockState(this.worldPosition.below());
        this.mode = below.getBlock() instanceof SpawnerBlock ? Mode.RUNNING : Mode.FINISHED;
    }

    public static enum Mode {
        INIT,
        RUNNING,
        FINISHED;

    }
}

