/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.block.entity.processing.RefineryOutputBlockEntity;
import me.desht.pneumaticcraft.common.inventory.RefineryMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.recipes.RecipeCaches;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.AcceptabilityCache;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class RefineryControllerBlockEntity
extends AbstractTickingBlockEntity
implements IRedstoneControl<RefineryControllerBlockEntity>,
IComparatorSupport,
ISerializableTanks,
MenuProvider,
IHeatExchangingTE {
    @GuiSynced
    @DescSynced
    private final RefineryInputTank inputTank = new RefineryInputTank(16000);
    @GuiSynced
    public final SyncOnlyTank[] outputsSynced = new SyncOnlyTank[4];
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    @GuiSynced
    private final RedstoneController<RefineryControllerBlockEntity> rsController = new RedstoneController<RefineryControllerBlockEntity>(this);
    @GuiSynced
    private boolean blocked;
    @GuiSynced
    public int minTemp;
    @GuiSynced
    public int maxTemp;
    @GuiSynced
    private String currentRecipeIdSynced = "";
    @DescSynced
    private int outputCount;
    @DescSynced
    private int lastProgress;
    private List<BlockCapabilityCache<IFluidHandler, Direction>> outputCache;
    private TemperatureRange operatingTemp = TemperatureRange.invalid();
    private RefineryRecipe currentRecipe;
    private int workTimer = 0;
    private int comparatorValue;
    private int prevOutputCount = -1;
    private boolean searchForRecipe = true;
    private int nPlayersUsing = 0;
    private static final AcceptabilityCache<Fluid> acceptedFluidCache = new AcceptabilityCache();

    public RefineryControllerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.REFINERY.get(), pos, state);
        for (int i = 0; i < 4; ++i) {
            this.outputsSynced[i] = new SyncOnlyTank(this, 16000);
        }
    }

    public static void clearCachedFluids() {
        acceptedFluidCache.clear();
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction dir) {
        return this.inputTank;
    }

    public static boolean isInputFluidValid(Level world, FluidStack fluid, int size) {
        return fluid.isEmpty() || acceptedFluidCache.isAcceptable(fluid.getFluid(), () -> ModRecipeTypes.REFINERY.get().findFirst(world, r -> r.getOutputs().size() <= size && r.getInput().test(fluid)).isPresent());
    }

    private Optional<RecipeHolder<RefineryRecipe>> findApplicableRecipe() {
        return ModRecipeTypes.REFINERY.get().stream(this.level).filter(r -> ((RefineryRecipe)r.value()).getOutputs().size() <= this.outputCount).filter(r -> ((RefineryRecipe)r.value()).getInput().test(this.inputTank.getFluid())).max(Comparator.comparingInt(r2 -> ((RefineryRecipe)r2.value()).getOutputs().size()));
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.inputTank.tick();
    }

    @Override
    public void tickClient() {
        RefineryOutputBlockEntity teRO;
        super.tickClient();
        if (this.lastProgress > 0 && (teRO = this.findAdjacentOutput()) != null) {
            for (int i = 0; i < this.lastProgress; ++i) {
                ClientUtils.emitParticles(this.getLevel(), teRO.getBlockPos().relative(Direction.UP, this.outputCount - 1), (ParticleOptions)ParticleTypes.SMOKE);
            }
        }
        for (SyncOnlyTank smartSyncTank : this.outputsSynced) {
            smartSyncTank.tick();
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.lastProgress = 0;
        this.getOutputCache();
        if (this.prevOutputCount != this.outputCount) {
            this.searchForRecipe = true;
        }
        if (this.searchForRecipe) {
            RecipeCaches.REFINERY.getCachedRecipe(this::findApplicableRecipe, this::genIngredientHash).ifPresentOrElse(holder -> {
                this.currentRecipe = (RefineryRecipe)holder.value();
                this.currentRecipeIdSynced = holder.id().toString();
                this.operatingTemp = this.currentRecipe.getOperatingTemp();
            }, () -> {
                this.currentRecipe = null;
                this.currentRecipeIdSynced = "";
                this.operatingTemp = TemperatureRange.invalid();
            });
            this.minTemp = this.operatingTemp.getMin();
            this.maxTemp = this.operatingTemp.getMax();
            this.searchForRecipe = false;
        }
        boolean hasWork = false;
        if (this.currentRecipe != null) {
            if (this.prevOutputCount != this.outputCount && this.outputCount > 1) {
                this.redistributeFluids();
            }
            if (this.outputCount > 1 && this.doesRedstoneAllow() && this.doRefiningStep(IFluidHandler.FluidAction.SIMULATE)) {
                hasWork = true;
                if (this.operatingTemp.inRange(this.heatExchanger.getTemperature()) && this.inputTank.getFluidAmount() >= this.currentRecipe.getInput().amount()) {
                    int progress = Math.max(0, ((int)this.heatExchanger.getTemperature() - (this.operatingTemp.getMin() - 30)) / 30);
                    progress = Math.min(5, progress);
                    this.heatExchanger.addHeat(-progress);
                    this.workTimer += progress;
                    while (this.workTimer >= 20 && this.inputTank.getFluidAmount() >= this.currentRecipe.getInput().amount()) {
                        this.workTimer -= 20;
                        this.doRefiningStep(IFluidHandler.FluidAction.EXECUTE);
                        this.inputTank.drain(this.currentRecipe.getInput().amount(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.lastProgress = progress;
                }
            } else {
                this.workTimer = 0;
            }
        }
        if (this.nPlayersUsing > 0) {
            for (int i = 0; i < this.outputCount; ++i) {
                int j = i;
                this.getOutputHandler(i).ifPresent(h -> {
                    if (!FluidStack.matches((FluidStack)this.outputsSynced[j].getFluid(), (FluidStack)h.getFluidInTank(0))) {
                        this.outputsSynced[j].setFluid(h.getFluidInTank(0).copy());
                        this.outputsSynced[j].tick();
                    }
                });
            }
        }
        this.prevOutputCount = this.outputCount;
        this.maybeUpdateComparatorValue(hasWork);
    }

    private void redistributeFluids() {
        int i;
        int nTanks = Math.min(this.outputCount, this.currentRecipe.getOutputs().size());
        FluidTank[] tempTanks = new FluidTank[nTanks];
        for (i = 0; i < nTanks; ++i) {
            tempTanks[i] = new FluidTank(16000);
        }
        for (i = 0; i < nTanks; ++i) {
            FluidStack wantedFluid = this.currentRecipe.getOutputs().get(i);
            this.getOutputHandler(i).ifPresent(outputHandler -> {
                FluidStack fluid = outputHandler.getFluidInTank(0);
                if (!FluidStack.isSameFluidSameComponents((FluidStack)fluid, (FluidStack)wantedFluid)) {
                    for (int j = 0; j < nTanks; ++j) {
                        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.currentRecipe.getOutputs().get(j), (FluidStack)fluid)) continue;
                        this.tryMoveFluid((IFluidHandler)outputHandler, (IFluidHandler)tempTanks[j]);
                        break;
                    }
                }
            });
        }
        for (i = 0; i < this.outputCount; ++i) {
            FluidTank tempTank = tempTanks[i];
            this.getOutputHandler(i).ifPresent(arg_0 -> this.lambda$redistributeFluids$9((IFluidHandler)tempTank, arg_0));
        }
    }

    private void tryMoveFluid(IFluidHandler sourceHandler, IFluidHandler destHandler) {
        int moved;
        FluidStack fluid = sourceHandler.drain(sourceHandler.getTankCapacity(0), IFluidHandler.FluidAction.SIMULATE);
        if (!fluid.isEmpty() && (moved = destHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
            sourceHandler.drain(moved, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void clearOutputCache() {
        this.outputCount = 0;
        this.outputCache = null;
    }

    private List<BlockCapabilityCache<IFluidHandler, Direction>> getOutputCache() {
        if (this.outputCache == null) {
            this.outputCache = new ArrayList<BlockCapabilityCache<IFluidHandler, Direction>>();
            RefineryOutputBlockEntity output = this.findAdjacentOutput();
            while (output != null) {
                this.outputCache.add((BlockCapabilityCache<IFluidHandler, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)output.getBlockPos(), (Object)Direction.DOWN, () -> !this.isRemoved(), () -> {
                    this.outputCache = null;
                }));
                BlockEntity te = this.getLevel().getBlockEntity(output.getBlockPos().above());
                output = te instanceof RefineryOutputBlockEntity ? (RefineryOutputBlockEntity)te : null;
            }
        }
        this.outputCount = this.outputCache.size();
        return this.outputCache;
    }

    private Optional<IFluidHandler> getOutputHandler(int n) {
        return n >= 0 && n < this.outputCount ? Optional.ofNullable((IFluidHandler)this.getOutputCache().get(n).getCapability()) : Optional.empty();
    }

    public RefineryOutputBlockEntity findAdjacentOutput() {
        for (Direction d : DirectionUtil.VALUES) {
            BlockEntity blockEntity;
            if (d == Direction.DOWN || !((blockEntity = this.getCachedNeighbor(d)) instanceof RefineryOutputBlockEntity)) continue;
            RefineryOutputBlockEntity output = (RefineryOutputBlockEntity)blockEntity;
            return output;
        }
        return null;
    }

    private boolean doRefiningStep(IFluidHandler.FluidAction action) {
        List<FluidStack> recipeOutputs = this.currentRecipe.getOutputs();
        for (int i = 0; i < this.outputCount && i < recipeOutputs.size(); ++i) {
            FluidStack outFluid = recipeOutputs.get(i);
            int filled = this.getOutputHandler(i).map(h -> h.fill(outFluid, action)).orElse(0);
            if (filled == outFluid.getAmount()) continue;
            this.blocked = true;
            return false;
        }
        this.blocked = false;
        return true;
    }

    private boolean doesRedstoneAllow() {
        int totalPower = this.getRedstoneController().getCurrentRedstonePower();
        RefineryOutputBlockEntity teRO = this.findAdjacentOutput();
        if (teRO != null) {
            while (teRO.getCachedNeighbor(Direction.UP) instanceof RefineryOutputBlockEntity) {
                totalPower = Math.max(totalPower, teRO.getRedstoneController().getCurrentRedstonePower());
                teRO = (RefineryOutputBlockEntity)teRO.getCachedNeighbor(Direction.UP);
            }
        }
        return switch (this.getRedstoneController().getCurrentMode()) {
            case 0 -> true;
            case 1 -> {
                if (totalPower > 0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (totalPower == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public String getCurrentRecipeIdSynced() {
        return this.currentRecipeIdSynced;
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    public IFluidTank getInputTank() {
        return this.inputTank;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public RedstoneController<RefineryControllerBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    private void maybeUpdateComparatorValue(boolean hasWork) {
        int newValue = hasWork && this.currentRecipe != null && this.inputTank.getFluidAmount() >= this.currentRecipe.getInput().amount() && this.outputCount >= this.currentRecipe.getOutputs().size() ? 15 : 0;
        if (newValue != this.comparatorValue) {
            this.comparatorValue = newValue;
            this.nonNullLevel().updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
            RefineryOutputBlockEntity output = this.findAdjacentOutput();
            while (output != null && !output.getBlockState().isAir()) {
                this.nonNullLevel().updateNeighbourForOutputSignal(output.getBlockPos(), output.getBlockState().getBlock());
                BlockEntity te = output.getCachedNeighbor(Direction.UP);
                output = te instanceof RefineryOutputBlockEntity ? (RefineryOutputBlockEntity)te : null;
            }
        }
    }

    @Override
    public int getComparatorValue() {
        return this.comparatorValue;
    }

    @Override
    @Nonnull
    public Map<DataComponentType<SimpleFluidContent>, PNCFluidTank> getSerializableTanks() {
        return Map.of(ModDataComponents.MAIN_TANK.get(), this.inputTank);
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new RefineryMenu(i, playerInventory, this.getBlockPos());
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }

    public void incPlayersUsing() {
        ++this.nPlayersUsing;
    }

    public void decPlayersUsing() {
        if (this.nPlayersUsing == 0) {
            Log.warning("decPlayersUsing() called for {} but already 0?", this);
        } else {
            this.nPlayersUsing = Math.max(0, this.nPlayersUsing - 1);
        }
    }

    private int genIngredientHash() {
        return Objects.hash(FluidStack.hashFluidAndComponents((FluidStack)this.getInputTank().getFluid()), this.outputCount);
    }

    private /* synthetic */ void lambda$redistributeFluids$9(IFluidHandler tempTank, IFluidHandler outputHandler) {
        this.tryMoveFluid(tempTank, outputHandler);
    }

    private class RefineryInputTank
    extends SmartSyncTank {
        RefineryInputTank(int capacity) {
            super(RefineryControllerBlockEntity.this, capacity);
        }

        @Override
        public boolean isFluidValid(FluidStack fluid) {
            return FluidStack.isSameFluidSameComponents((FluidStack)this.getFluid(), (FluidStack)fluid) || RefineryControllerBlockEntity.isInputFluidValid(RefineryControllerBlockEntity.this.level, fluid, 4);
        }

        @Override
        protected void onContentsChanged(FluidStack prevStack) {
            super.onContentsChanged(prevStack);
            if (!FluidStack.isSameFluidSameComponents((FluidStack)prevStack, (FluidStack)this.getFluid()) || RefineryControllerBlockEntity.this.currentRecipe == null && this.getFluidAmount() > prevStack.getAmount() || RefineryControllerBlockEntity.this.currentRecipe != null && this.getFluidAmount() < prevStack.getAmount()) {
                RefineryControllerBlockEntity.this.searchForRecipe = true;
            }
        }
    }

    public static class SyncOnlyTank
    extends SmartSyncTank {
        SyncOnlyTank(BlockEntity owner, int capacity) {
            super(owner, capacity);
        }

        @Override
        protected void onContentsChanged(FluidStack prevStack) {
        }
    }
}

