/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tube_module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.tube_module.AbstractTubeModuleRenderer;
import me.desht.pneumaticcraft.common.tubemodules.RedstoneModule;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

public class RedstoneRenderer
extends AbstractTubeModuleRenderer<RedstoneModule> {
    private final ModelPart redstoneConnector;
    private final ModelPart faceplate;
    private final ModelPart tubeConnector1;
    private final ModelPart tubeConnector2;
    private final ModelPart tubeConnector3;
    private final ModelPart tubeConnector4;
    private final ModelPart tubeConnector5;
    private final ModelPart tubeConnector6;
    private final ModelPart frame1;
    private final ModelPart frame2;
    private final ModelPart frame3;
    private final ModelPart frame4;
    private static final String REDSTONECONNECTOR = "redstoneConnector";
    private static final String FACEPLATE = "faceplate";
    private static final String TUBECONNECTOR1 = "tubeConnector1";
    private static final String TUBECONNECTOR2 = "tubeConnector2";
    private static final String TUBECONNECTOR3 = "tubeConnector3";
    private static final String TUBECONNECTOR4 = "tubeConnector4";
    private static final String TUBECONNECTOR5 = "tubeConnector5";
    private static final String TUBECONNECTOR6 = "tubeConnector6";
    private static final String FRAME1 = "frame1";
    private static final String FRAME2 = "frame2";
    private static final String FRAME3 = "frame3";
    private static final String FRAME4 = "frame4";

    public RedstoneRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart root = ctx.bakeLayer(PNCModelLayers.REDSTONE_MODULE);
        this.redstoneConnector = root.getChild(REDSTONECONNECTOR);
        this.faceplate = root.getChild(FACEPLATE);
        this.tubeConnector1 = root.getChild(TUBECONNECTOR1);
        this.tubeConnector2 = root.getChild(TUBECONNECTOR2);
        this.tubeConnector3 = root.getChild(TUBECONNECTOR3);
        this.tubeConnector4 = root.getChild(TUBECONNECTOR4);
        this.tubeConnector5 = root.getChild(TUBECONNECTOR5);
        this.tubeConnector6 = root.getChild(TUBECONNECTOR6);
        this.frame1 = root.getChild(FRAME1);
        this.frame2 = root.getChild(FRAME2);
        this.frame3 = root.getChild(FRAME3);
        this.frame4 = root.getChild(FRAME4);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(REDSTONECONNECTOR, CubeListBuilder.create().texOffs(0, 0).addBox("redstoneConnector_0", 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)6.05f));
        partdefinition.addOrReplaceChild(FACEPLATE, CubeListBuilder.create().texOffs(12, 0).addBox("faceplate_0", 0.0f, 0.0f, -1.0f, 8.0f, 8.0f, 2.0f), PartPose.offset((float)-4.0f, (float)12.0f, (float)5.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR1, CubeListBuilder.create().texOffs(12, 10).addBox("tubeConnector1_0", -2.0f, -2.0f, 1.0f, 7.0f, 7.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR2, CubeListBuilder.create().texOffs(12, 18).addBox("tubeConnector2_0", -1.0f, -1.0f, 0.0f, 5.0f, 5.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR3, CubeListBuilder.create().texOffs(28, 12).addBox("tubeConnector3_0", 4.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR4, CubeListBuilder.create().texOffs(28, 16).addBox("tubeConnector4_0", 0.0f, 4.0f, 0.0f, 3.0f, 1.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR5, CubeListBuilder.create().texOffs(32, 12).addBox("tubeConnector5_0", -2.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR6, CubeListBuilder.create().texOffs(28, 10).addBox("tubeConnector6_0", 0.0f, -2.0f, 0.0f, 3.0f, 1.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(FRAME1, CubeListBuilder.create().texOffs(32, 0).addBox("frame1_0", 2.0f, 1.5f, -3.75f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)-4.0f, (float)11.5f, (float)6.0f));
        partdefinition.addOrReplaceChild(FRAME2, CubeListBuilder.create().texOffs(32, 5).addBox("frame2_0", 2.0f, -1.5f, -3.75f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)-4.0f, (float)19.5f, (float)6.0f));
        partdefinition.addOrReplaceChild(FRAME3, CubeListBuilder.create().texOffs(0, 6).addBox("frame3_0", -1.5f, 0.5f, -3.75f, 1.0f, 6.0f, 4.0f), PartPose.offset((float)3.5f, (float)12.5f, (float)6.0f));
        partdefinition.addOrReplaceChild(FRAME4, CubeListBuilder.create().texOffs(0, 16).addBox("frame4_0", 1.5f, 0.5f, -3.75f, 1.0f, 6.0f, 4.0f), PartPose.offset((float)-4.5f, (float)12.5f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @Override
    protected void render(RedstoneModule module, PoseStack poseStack, VertexConsumer builder, float partialTicks, int combinedLight, int combinedOverlay, int alpha) {
        int baseColor = FastColor.ARGB32.color((int)alpha, (int)0xFFFFFF);
        this.tubeConnector1.render(poseStack, builder, combinedLight, combinedOverlay, baseColor);
        this.tubeConnector2.render(poseStack, builder, combinedLight, combinedOverlay, baseColor);
        this.tubeConnector3.render(poseStack, builder, combinedLight, combinedOverlay, baseColor);
        this.tubeConnector4.render(poseStack, builder, combinedLight, combinedOverlay, baseColor);
        this.tubeConnector5.render(poseStack, builder, combinedLight, combinedOverlay, baseColor);
        this.tubeConnector6.render(poseStack, builder, combinedLight, combinedOverlay, baseColor);
        this.faceplate.render(poseStack, builder, combinedLight, combinedOverlay, baseColor);
        if (module.isFake()) {
            this.redstoneConnector.render(poseStack, builder, combinedLight, combinedOverlay, -1);
        } else {
            int rsLevel = module.getRedstoneDirection() == RedstoneModule.EnumRedstoneDirection.INPUT ? module.getInputLevel() : module.getRedstoneLevel();
            poseStack.pushPose();
            poseStack.translate(0.0, 0.0, 0.325);
            poseStack.scale(1.0f, 1.0f, 0.25f + 0.72f * Mth.lerp((float)partialTicks, (float)module.lastExtension, (float)module.extension));
            poseStack.translate(0.0, 0.0, -0.325);
            this.redstoneConnector.render(poseStack, builder, combinedLight, combinedOverlay, 0xFF300000 | rsLevel * 13 << 16);
            poseStack.popPose();
        }
        int frameColor = FastColor.ARGB32.color((int)alpha, (int)DyeColor.byId((int)module.getColorChannel()).getTextureDiffuseColor());
        this.frame1.render(poseStack, builder, combinedLight, combinedOverlay, frameColor);
        this.frame2.render(poseStack, builder, combinedLight, combinedOverlay, frameColor);
        this.frame3.render(poseStack, builder, combinedLight, combinedOverlay, frameColor);
        this.frame4.render(poseStack, builder, combinedLight, combinedOverlay, frameColor);
    }

    @Override
    protected ResourceLocation getTexture(boolean isUpgraded) {
        return isUpgraded ? Textures.MODEL_REDSTONE_MODULE_UPGRADED : Textures.MODEL_REDSTONE_MODULE;
    }
}

