/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.IKeyListener;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorColoringScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.ComponentInit;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeatureBulk;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public enum HUDHandler implements IKeyListener
{
    INSTANCE;

    private int lastScaledWidth = -1;
    private int lastScaledHeight = -1;
    private long lastArmorInitSound;
    private long lastArmorInitCompleteSound;
    private boolean sentForceInitPacket = false;
    private final List<ArmorMessage> pendingMessages = new ArrayList<ArmorMessage>();

    public static HUDHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderHUD3d(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.options.hideGui || mc.screen != null || !PneumaticArmorItem.isPneumaticArmorPiece((Player)player, EquipmentSlot.HEAD) || WidgetKeybindCheckBox.getCoreComponents() == null || !WidgetKeybindCheckBox.getCoreComponents().checked) {
            return;
        }
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer((Player)player);
        if (commonArmorHandler.getArmorPressure(EquipmentSlot.HEAD) > 0.0f) {
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            poseStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
            for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                if (!commonArmorHandler.isArmorReady(slot)) continue;
                List<IArmorUpgradeClientHandler<?>> clientHandlers = ClientArmorRegistry.getInstance().getHandlersForSlot(slot);
                for (int i = 0; i < clientHandlers.size(); ++i) {
                    if (!commonArmorHandler.isUpgradeInserted(slot, i) || !WidgetKeybindCheckBox.forUpgrade(clientHandlers.get((int)i)).checked) continue;
                    clientHandlers.get(i).render3D(poseStack, (MultiBufferSource)buffer, event.getPartialTick().getGameTimeDeltaPartialTick(true));
                }
            }
            poseStack.popPose();
        }
    }

    @SubscribeEvent
    public void playerTick(PlayerTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        Player player = event.getEntity();
        if (player == mc.player && player.level().isClientSide) {
            boolean anyArmorEquipped = false;
            CommonArmorHandler comHudHandler = CommonArmorHandler.getHandlerForPlayer();
            for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                if (!PneumaticArmorItem.isPneumaticArmorPiece(player, slot)) continue;
                this.tickArmorPiece((Player)mc.player, slot, comHudHandler);
                anyArmorEquipped = true;
            }
            if (anyArmorEquipped) {
                this.ensureArmorInit(player, comHudHandler);
                this.pendingMessages.forEach(ArmorMessage::tick);
                this.pendingMessages.removeIf(message -> message == null || message.isExpired());
            } else {
                this.pendingMessages.clear();
                this.sentForceInitPacket = false;
            }
        }
    }

    private void ensureArmorInit(Player player, CommonArmorHandler commonArmorHandler) {
        if (!PneumaticArmorItem.isPneumaticArmorPiece(player, EquipmentSlot.HEAD) && !this.sentForceInitPacket) {
            boolean state = WidgetKeybindCheckBox.getCoreComponents().checked;
            if (state) {
                commonArmorHandler.setUpgradeEnabled(EquipmentSlot.HEAD, (byte)0, true);
                NetworkHandler.sendToServer(new PacketToggleArmorFeature(new PacketToggleArmorFeature.FeatureSetting(EquipmentSlot.HEAD, 0, true)));
            }
            this.sentForceInitPacket = true;
        }
    }

    private void tickArmorPiece(Player player, EquipmentSlot slot, CommonArmorHandler commonArmorHandler) {
        block8: {
            int startupTime;
            int ticksSinceEquipped;
            List<IArmorUpgradeHandler<?>> upgradeHandlers;
            block11: {
                Component itemName;
                block10: {
                    boolean armorEnabled;
                    block9: {
                        block7: {
                            armorEnabled = WidgetKeybindCheckBox.getCoreComponents().checked;
                            upgradeHandlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
                            List<IArmorUpgradeClientHandler<?>> clientHandlers = ClientArmorRegistry.getInstance().getHandlersForSlot(slot);
                            ItemStack armorStack = player.getItemBySlot(slot);
                            ticksSinceEquipped = commonArmorHandler.getTicksSinceEquipped(slot);
                            startupTime = commonArmorHandler.getStartupTime(slot);
                            itemName = armorStack.getHoverName();
                            if (ticksSinceEquipped <= startupTime || !armorEnabled) break block7;
                            for (int i = 0; i < upgradeHandlers.size(); ++i) {
                                IGuiAnimatedStat stat;
                                if (!commonArmorHandler.isUpgradeInserted(slot, i)) continue;
                                IArmorUpgradeClientHandler<?> clientHandler = clientHandlers.get(i);
                                if ((!clientHandler.isToggleable() || commonArmorHandler.isUpgradeEnabled(slot, i)) && (stat = clientHandler.getAnimatedStat()) != null) {
                                    IArmorUpgradeHandler<?> upgradeHandler = upgradeHandlers.get(i);
                                    if (commonArmorHandler.getArmorPressure(slot) > upgradeHandler.getMinimumPressure()) {
                                        stat.openStat();
                                    } else {
                                        stat.closeStat();
                                    }
                                    stat.tickWidget();
                                }
                                clientHandler.tickClient(commonArmorHandler, commonArmorHandler.isUpgradeEnabled(slot, i));
                            }
                            break block8;
                        }
                        if (ticksSinceEquipped != startupTime) break block9;
                        this.playArmorInitCompleteSound(player);
                        this.addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.initComplete", itemName), 50, 0x7000AA00));
                        player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.armor.message.configureHint", (Object[])new Object[]{ClientUtils.translateKeyBind(KeyHandler.getInstance().keybindOpenOptions)}).withStyle(ChatFormatting.YELLOW), true);
                        break block8;
                    }
                    if (ticksSinceEquipped != 0 || !WidgetKeybindCheckBox.getCoreComponents().checked) break block10;
                    for (IArmorUpgradeClientHandler<?> handler : ClientArmorRegistry.getInstance().getHandlersForSlot(slot)) {
                        handler.reset();
                    }
                    ArrayList<PacketToggleArmorFeature.FeatureSetting> features = new ArrayList<PacketToggleArmorFeature.FeatureSetting>();
                    for (byte idx = 0; idx < upgradeHandlers.size(); idx = (byte)(idx + 1)) {
                        boolean state = armorEnabled && WidgetKeybindCheckBox.forUpgrade(upgradeHandlers.get((int)idx)).checked;
                        commonArmorHandler.setUpgradeEnabled(slot, idx, state);
                        features.add(new PacketToggleArmorFeature.FeatureSetting(slot, idx, state));
                    }
                    NetworkHandler.sendToServer(new PacketToggleArmorFeatureBulk(features));
                    break block8;
                }
                if (ticksSinceEquipped != 1) break block11;
                this.playArmorInitSound(player, 0.5f);
                this.addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.initStarted", itemName), 50, 0x7000AA00));
                break block8;
            }
            ComponentInit initWhen = (ComponentInit)ConfigHelper.client().armor.componentInitMessages.get();
            if (initWhen == ComponentInit.NONE) break block8;
            for (int i = 0; i < upgradeHandlers.size(); ++i) {
                if (ticksSinceEquipped != startupTime / (upgradeHandlers.size() + 2) * (i + 1)) continue;
                boolean upgradeInstalled = commonArmorHandler.isUpgradeInserted(slot, i);
                if (initWhen != ComponentInit.ALL && !upgradeInstalled) continue;
                this.playArmorInitSound(player, 0.5f + (float)(i + 1) / (float)(upgradeHandlers.size() + 2) * 0.5f);
                String key = "pneumaticcraft.armor.message.upgrade" + (upgradeInstalled ? "Installed" : "NotInstalled");
                MutableComponent message = PneumaticCraftUtils.xlate(key, PneumaticCraftUtils.xlate(upgradeHandlers.get(i).getTranslationKey(), new Object[0]));
                this.addMessage(new ArmorMessage((Component)message, 80, upgradeInstalled ? 0x7000AA00 : 1895792640));
            }
        }
    }

    private void playArmorInitSound(Player player, float pitch) {
        long when = player.level().getGameTime();
        if (when - this.lastArmorInitSound >= 30L) {
            player.playNotifySound((SoundEvent)ModSounds.HUD_INIT.get(), SoundSource.PLAYERS, ((Double)ConfigHelper.client().sound.armorInitVolume.get()).floatValue(), pitch);
        }
        this.lastArmorInitSound = when;
    }

    private void playArmorInitCompleteSound(Player player) {
        long when = player.level().getGameTime();
        if (when - this.lastArmorInitCompleteSound >= 30L) {
            player.playNotifySound((SoundEvent)ModSounds.HUD_INIT_COMPLETE.get(), SoundSource.PLAYERS, ((Double)ConfigHelper.client().sound.armorInitVolume.get()).floatValue(), 1.0f);
        }
        this.lastArmorInitCompleteSound = when;
    }

    public void addFeatureToggleMessage(String key, boolean enabled) {
        this.addMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message." + (enabled ? "enable" : "disable") + "Setting", PneumaticCraftUtils.xlate(key, new Object[0])), Collections.emptyList(), 60, 0x7000AA00);
    }

    public void addFeatureToggleMessage(String key, String subKey, boolean enabled) {
        MutableComponent msg = PneumaticCraftUtils.xlate(key, new Object[0]).append(": ").append((Component)PneumaticCraftUtils.xlate(subKey, new Object[0]));
        this.addMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message." + (enabled ? "enable" : "disable") + "Setting", msg), Collections.emptyList(), 60, 0x7000AA00);
    }

    public void addMessage(Component title, List<Component> message, int duration, int backColor) {
        this.addMessage(new ArmorMessage(title, message, duration, backColor));
    }

    public void addMessage(ArmorMessage message) {
        if (!this.pendingMessages.isEmpty()) {
            message.setDependingMessage(this.pendingMessages.getLast().getStat());
        }
        this.pendingMessages.add(message);
    }

    @Override
    public void handleInput(KeyMapping key) {
        if (Minecraft.getInstance().isWindowActive()) {
            ClientArmorRegistry.getInstance().getTriggeredHandler(key).ifPresent(h -> h.onTriggered(CommonArmorHandler.getHandlerForPlayer()));
        }
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        ClientArmorRegistry c = ClientArmorRegistry.getInstance();
        if (c.getClientHandler(CommonUpgradeHandlers.blockTrackerHandler, BlockTrackerClientHandler.class).scroll(event) || c.getClientHandler(CommonUpgradeHandlers.entityTrackerHandler, EntityTrackerClientHandler.class).scroll(event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleResolutionChange(ScreenEvent.Init.Post event) {
        Window mw;
        Screen gui = event.getScreen();
        if (gui.getMinecraft() != null && gui.getMinecraft().level != null && ((mw = gui.getMinecraft().getWindow()).getGuiScaledWidth() != this.lastScaledWidth || mw.getGuiScaledHeight() != this.lastScaledHeight)) {
            ClientArmorRegistry c = ClientArmorRegistry.getInstance();
            for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                c.getHandlersForSlot(slot).forEach(IArmorUpgradeClientHandler::onResolutionChanged);
            }
            this.lastScaledWidth = mw.getGuiScaledWidth();
            this.lastScaledHeight = mw.getGuiScaledHeight();
        }
    }

    public int getStatOverlayColor() {
        int n;
        ItemStack stack = ClientUtils.getClientPlayer().getItemBySlot(EquipmentSlot.HEAD);
        Item item = stack.getItem();
        if (item instanceof PneumaticArmorItem) {
            PneumaticArmorItem helmet = (PneumaticArmorItem)item;
            n = helmet.getEyepieceColor(stack);
        } else {
            n = ArmorColoringScreen.SelectorType.EYEPIECE.getDefaultColor();
        }
        int eyepieceColor = n;
        return eyepieceColor & 0xFFFFFF | 0x30000000;
    }

    public void updateOverlayColors(EquipmentSlot slot) {
        int color = this.getStatOverlayColor();
        ClientArmorRegistry.getInstance().getHandlersForSlot(slot).forEach(clientHandler -> clientHandler.setOverlayColor(color));
    }

    public void renderMessages(GuiGraphics poseStack, float partialTicks) {
        this.pendingMessages.forEach(message -> message.renderMessage(poseStack, partialTicks));
    }
}

