/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.api.client.assembly_machine.IAssemblyRenderOverriding;
import me.desht.pneumaticcraft.client.ClientRegistryImpl;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyPlatformBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;

public class AssemblyPlatformRenderer
extends AbstractBlockEntityModelRenderer<AssemblyPlatformBlockEntity> {
    private static final float ITEM_SCALE = 0.5f;
    private final ModelPart claw1;
    private final ModelPart claw2;
    private static final String CLAW1 = "claw1";
    private static final String CLAW2 = "claw2";

    public AssemblyPlatformRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.ASSEMBLY_PLATFORM);
        this.claw1 = root.getChild(CLAW1);
        this.claw2 = root.getChild(CLAW2);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(CLAW1, CubeListBuilder.create().texOffs(0, 0).addBox("claw1_0", -0.5f, 0.0f, 0.1f, 3, 1, 1, new CubeDeformation(-0.1f), 0, 12).addBox("claw1_1", -0.5f, 0.0f, 0.6f, 3, 1, 1, 8, 14).mirror(), PartPose.offset((float)-1.0f, (float)17.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(CLAW2, CubeListBuilder.create().texOffs(0, 0).addBox("claw2_0", -0.5f, 0.0f, -0.1f, 3, 1, 1, new CubeDeformation(-0.1f), 0, 14).addBox("claw2_1", -0.5f, 0.0f, -0.6f, 3, 1, 1, 8, 12).mirror(), PartPose.offset((float)-1.0f, (float)17.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void renderModel(AssemblyPlatformBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IAssemblyRenderOverriding renderOverride;
        ItemStack heldStack = te.getItemHandler(null).getStackInSlot(0);
        Pair<IAssemblyRenderOverriding, Float> clawTranslation = this.getClawTranslation(Mth.lerp((float)partialTicks, (float)te.oldClawProgress, (float)te.clawProgress), heldStack);
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_ASSEMBLY_PLATFORM));
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0f, 0.0f, ((Float)clawTranslation.getRight()).floatValue());
        this.claw1.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(0.0f, 0.0f, -2.0f * ((Float)clawTranslation.getRight()).floatValue());
        this.claw2.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.popPose();
        if (!heldStack.isEmpty() && ((renderOverride = (IAssemblyRenderOverriding)clawTranslation.getLeft()) == null || renderOverride.applyRenderChangePlatform(matrixStackIn, heldStack))) {
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
            double yOffset = heldStack.getItem() instanceof BlockItem ? -1.03125 : -1.09375;
            matrixStackIn.translate(0.0, yOffset + 0.05, 0.0);
            matrixStackIn.scale(0.5f, 0.5f, 0.5f);
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            BakedModel bakedModel = itemRenderer.getModel(heldStack, te.getLevel(), null, 0);
            itemRenderer.render(heldStack, ItemDisplayContext.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, bakedModel);
        }
    }

    private Pair<IAssemblyRenderOverriding, Float> getClawTranslation(float clawProgress, ItemStack heldStack) {
        IAssemblyRenderOverriding renderOverride = ClientRegistryImpl.getInstance().getAssemblyRenderOverride((ItemLike)heldStack.getItem());
        float clawTrans = !heldStack.isEmpty() ? (renderOverride != null ? renderOverride.getPlatformClawShift(heldStack) : (heldStack.getItem() instanceof BlockItem ? 0.09375f - clawProgress * 0.1f / 16.0f : 0.09375f - clawProgress * 1.4f / 16.0f)) : 0.09375f - clawProgress * 1.5f / 16.0f;
        return Pair.of((Object)renderOverride, (Object)Float.valueOf(clawTrans));
    }
}

