/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCrafting;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class ProgWidgetRenderer {
    private static final Map<ProgWidgetType<?>, BiConsumer<GuiGraphics, IProgWidget>> ITEM_RENDERERS = new HashMap();
    private static final Map<ProgWidgetType<?>, BiConsumer<GuiGraphics, IProgWidget>> EXTRA_RENDERERS = new HashMap();

    public static void renderProgWidget2d(GuiGraphics graphics, IProgWidget progWidget, int alpha) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)progWidget.getTexture());
        int width = progWidget.getWidth() + (progWidget.getParameters().isEmpty() ? 0 : 10);
        int height = progWidget.getHeight() + (progWidget.hasStepOutput() ? 10 : 0);
        Pair<Float, Float> maxUV = progWidget.getMaxUV();
        float u = ((Float)maxUV.getLeft()).floatValue();
        float v = ((Float)maxUV.getRight()).floatValue();
        Matrix4f posMat = graphics.pose().last().pose();
        BufferBuilder wr = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        wr.addVertex(posMat, 0.0f, 0.0f, 0.0f).setUv(0.0f, 0.0f).setColor(255, 255, 255, alpha);
        wr.addVertex(posMat, 0.0f, (float)height, 0.0f).setUv(0.0f, v).setColor(255, 255, 255, alpha);
        wr.addVertex(posMat, (float)width, (float)height, 0.0f).setUv(u, v).setColor(255, 255, 255, alpha);
        wr.addVertex(posMat, (float)width, 0.0f, 0.0f).setUv(u, 0.0f).setColor(255, 255, 255, alpha);
        BufferUploader.drawWithShader((MeshData)wr.buildOrThrow());
    }

    public static void renderProgWidget2d(GuiGraphics graphics, IProgWidget progWidget) {
        ProgWidgetRenderer.renderProgWidget2d(graphics, progWidget, 255);
    }

    public static void renderProgWidget3d(PoseStack matrixStack, MultiBufferSource buffer, IProgWidget progWidget) {
        int width = progWidget.getWidth() + (progWidget.getParameters().isEmpty() ? 0 : 10);
        int height = progWidget.getHeight() + (progWidget.hasStepOutput() ? 10 : 0);
        Pair<Float, Float> maxUV = progWidget.getMaxUV();
        float u = ((Float)maxUV.getLeft()).floatValue();
        float v = ((Float)maxUV.getRight()).floatValue();
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(progWidget.getTexture()), (posMat, builder) -> {
            builder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(0xF000F0);
            builder.addVertex(posMat, (float)width, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u, 0.0f).setLight(0xF000F0);
            builder.addVertex(posMat, (float)width, (float)height, 0.0f).setColor(255, 255, 255, 255).setUv(u, v).setLight(0xF000F0);
            builder.addVertex(posMat, 0.0f, (float)height, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, v).setLight(0xF000F0);
        });
    }

    public static void doExtraRendering2d(GuiGraphics graphics, IProgWidget widget) {
        EXTRA_RENDERERS.getOrDefault(widget.getType(), ProgWidgetRenderer::renderGenericExtras).accept(graphics, widget);
    }

    public static void doItemRendering2d(GuiGraphics graphics, IProgWidget widget) {
        ITEM_RENDERERS.getOrDefault(widget.getType(), (p, w) -> {}).accept(graphics, widget);
    }

    public static <P extends IProgWidget> void registerExtraRenderer(ProgWidgetType<P> type, BiConsumer<GuiGraphics, P> consumer) {
        EXTRA_RENDERERS.put(type, consumer);
    }

    public static <P extends IProgWidget> void registerItemRenderer(ProgWidgetType<P> type, BiConsumer<GuiGraphics, P> consumer) {
        ITEM_RENDERERS.put(type, consumer);
    }

    public static void renderGenericExtras(GuiGraphics graphics, IProgWidget progWidget) {
        List<Component> info = progWidget.getExtraStringInfo();
        if (!info.isEmpty()) {
            graphics.pose().pushPose();
            graphics.pose().scale(0.5f, 0.5f, 0.5f);
            Font fr = Minecraft.getInstance().font;
            List<FormattedCharSequence> splittedInfo = GuiUtils.wrapTextComponentList(info, 150, fr);
            for (int i = 0; i < splittedInfo.size(); ++i) {
                int stringWidth = fr.width(splittedInfo.get(i));
                int startX = progWidget.getWidth() / 2 - stringWidth / 4;
                int n = progWidget.getHeight() / 2;
                Objects.requireNonNull(fr);
                int n2 = n - (9 + 1) * (splittedInfo.size() - 1) / 4;
                Objects.requireNonNull(fr);
                int n3 = n2 + (9 + 1) * i / 2;
                Objects.requireNonNull(fr);
                int startY = n3 - 9 / 4;
                Objects.requireNonNull(fr);
                graphics.fill(startX * 2 - 1, startY * 2 - 1, startX * 2 + stringWidth + 1, startY * 2 + 9 + 1, -1056964609);
                Objects.requireNonNull(fr);
                graphics.renderOutline(startX * 2 - 1, startY * 2 - 1, stringWidth + 2, 9 + 2, -4144960);
                graphics.drawString(fr, splittedInfo.get(i), startX * 2, startY * 2, -16777216, false);
            }
            graphics.pose().popPose();
        }
    }

    public static void renderCraftingItem(GuiGraphics graphics, ProgWidgetCrafting progWidget) {
        ItemStack recipe = progWidget.getRecipeResult(ClientUtils.getClientLevel());
        if (recipe != null) {
            graphics.renderItem(recipe, 8, progWidget.getHeight() / 2 - 8);
            graphics.renderItemDecorations(Minecraft.getInstance().font, recipe, 8, progWidget.getHeight() / 2 - 8, Integer.toString(recipe.getCount()));
        }
    }

    public static void renderItemFilterItem(GuiGraphics graphics, ProgWidgetItemFilter progWidget) {
        if (progWidget.getVariable().isEmpty() && !progWidget.getFilter().isEmpty()) {
            graphics.renderItem(progWidget.getFilter(), 10, 2);
            graphics.renderItemDecorations(Minecraft.getInstance().font, progWidget.getFilter(), 10, 2, "");
        }
    }
}

