/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils;

import com.heaser.pipeconnector.constants.ComponentDataTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class NodeParameter {
    public BlockPos position;
    public Direction direction;

    public NodeParameter(BlockPos position, Direction direction) {
        this.position = position;
        this.direction = direction;
    }

    public NodeParameter(CompoundTag nodeTag) {
        int x = nodeTag.getInt(ComponentDataTags.kPipeConnectorNodePositionX);
        int y = nodeTag.getInt(ComponentDataTags.kPipeConnectorNodePositionY);
        int z = nodeTag.getInt(ComponentDataTags.kPipeConnectorNodePositionZ);
        this.position = new BlockPos(x, y, z);
        this.direction = !nodeTag.contains(ComponentDataTags.kPipeConnectorNodeDirection) ? null : Direction.from3DDataValue((int)nodeTag.getByte(ComponentDataTags.kPipeConnectorNodeDirection));
    }

    public boolean equals(NodeParameter other) {
        if (this.direction == null || other.direction == null) {
            return this.position.equals((Object)other.position);
        }
        boolean positionEquals = this.position.equals((Object)other.position);
        boolean directionEquals = this.direction.equals((Object)other.direction);
        return positionEquals && directionEquals;
    }

    public BlockPos getRelativePosition() {
        if (this.direction == null) {
            return this.position;
        }
        return this.position.relative(this.direction);
    }
}

