/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.network;

import com.heaser.pipeconnector.network.CustomPipeConnectorPayload;
import com.heaser.pipeconnector.network.ServerboundPacket;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.TagUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record UpdateSolidPreview(boolean solid) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateSolidPreview> STREAM_CODEC = StreamCodec.ofMember(UpdateSolidPreview::write, UpdateSolidPreview::decode);
    public static final CustomPacketPayload.Type<UpdateSolidPreview> TYPE = CustomPipeConnectorPayload.createType("update_solid_preview");

    public CustomPacketPayload.Type<UpdateSolidPreview> type() {
        return TYPE;
    }

    public static UpdateSolidPreview decode(RegistryFriendlyByteBuf buf) {
        return new UpdateSolidPreview(buf.readBoolean());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.solid);
    }

    @Override
    public void handleOnServer(ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        if (!GeneralUtils.isHoldingPipeConnector((Player)sender)) {
            return;
        }
        ItemStack item = sender.getMainHandItem();
        TagUtils.setSolidPreview(item, this.solid);
    }
}

