/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.network;

import com.heaser.pipeconnector.PipeConnector;
import com.heaser.pipeconnector.network.BuildPipesPacket;
import com.heaser.pipeconnector.network.ClientboundPacket;
import com.heaser.pipeconnector.network.ResetPacket;
import com.heaser.pipeconnector.network.ServerboundPacket;
import com.heaser.pipeconnector.network.UpdateAvoidInventoryBlocks;
import com.heaser.pipeconnector.network.UpdateBridgeTypePacket;
import com.heaser.pipeconnector.network.UpdateDepthPacket;
import com.heaser.pipeconnector.network.UpdateInventoryGuard;
import com.heaser.pipeconnector.network.UpdateSolidPreview;
import com.heaser.pipeconnector.network.UpdateUtilizeExistingPipes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NetworkHandler {
    public static void register(RegisterPayloadHandlersEvent event) {
        int packetId = 0;
        PayloadRegistrar registrar = event.registrar("pipe_connector");
        NetworkHandler.serverbound(registrar, UpdateUtilizeExistingPipes.TYPE, UpdateUtilizeExistingPipes.STREAM_CODEC);
        NetworkHandler.serverbound(registrar, UpdateInventoryGuard.TYPE, UpdateInventoryGuard.STREAM_CODEC);
        NetworkHandler.serverbound(registrar, UpdateAvoidInventoryBlocks.TYPE, UpdateAvoidInventoryBlocks.STREAM_CODEC);
        NetworkHandler.serverbound(registrar, UpdateDepthPacket.TYPE, UpdateDepthPacket.STREAM_CODEC);
        NetworkHandler.serverbound(registrar, UpdateBridgeTypePacket.TYPE, UpdateBridgeTypePacket.STREAM_CODEC);
        NetworkHandler.serverbound(registrar, UpdateSolidPreview.TYPE, UpdateSolidPreview.STREAM_CODEC);
        NetworkHandler.serverbound(registrar, ResetPacket.TYPE, ResetPacket.STREAM_CODEC);
        NetworkHandler.serverbound(registrar, BuildPipesPacket.TYPE, BuildPipesPacket.STREAM_CODEC);
        PipeConnector.LOGGER.debug("Registered {} Packets for {}", (Object)packetId, (Object)"pipe_connector");
    }

    private static <T extends ClientboundPacket> void clientbound(PayloadRegistrar registrar, CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        registrar.playToClient(type, codec, ClientboundPacket::handleOnClient);
    }

    private static <T extends ServerboundPacket> void serverbound(PayloadRegistrar registrar, CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        registrar.playToServer(type, codec, ServerboundPacket::handleOnServer);
    }

    private static <T extends ServerboundPacket & ClientboundPacket> void bidirectional(PayloadRegistrar registrar, CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        registrar.playBidirectional(type, codec, (payload, context) -> {
            if (context.flow().isClientbound()) {
                ((ClientboundPacket)((Object)payload)).handleOnClient(context);
            } else if (context.flow().isServerbound()) {
                payload.handleOnServer(context);
            }
        });
    }
}

