/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.gui.buttons;

import com.heaser.pipeconnector.client.gui.buttons.BaseButton;
import com.heaser.pipeconnector.constants.BridgeType;
import com.heaser.pipeconnector.network.UpdateBridgeTypePacket;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class BridgeTypeButton
extends BaseButton {
    public BridgeTypeButton(ItemStack itemStack) {
        super(BridgeTypeButton.getInitialLabel(itemStack), 20, 123);
    }

    @Override
    public void onClick(Button clickedButton, ItemStack itemStack) {
        BridgeType bridgeType = TagUtils.getBridgeType(itemStack);
        if (bridgeType == BridgeType.DEFAULT) {
            bridgeType = BridgeType.A_STAR;
            this.setLabel("item.pipe_connector.gui.button.aStarPathfinding", null);
            this.button.setMessage(this.getLabel());
        } else if (bridgeType == BridgeType.A_STAR) {
            bridgeType = BridgeType.DEFAULT;
            this.setLabel("item.pipe_connector.gui.button.defaultPathfinding", null);
            this.button.setMessage(this.getLabel());
        }
        TagUtils.setBridgeType(itemStack, bridgeType);
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateBridgeTypePacket(bridgeType.toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static Component getInitialLabel(ItemStack itemStack) {
        BridgeType bridgeType = TagUtils.getBridgeType(itemStack);
        return switch (bridgeType) {
            case BridgeType.A_STAR -> Component.translatable((String)"item.pipe_connector.gui.button.aStarPathfinding");
            default -> Component.translatable((String)"item.pipe_connector.gui.button.defaultPathfinding");
        };
    }

    @Override
    public List<Component> getTooltipList(ItemStack itemStack) {
        ArrayList<Component> tooltipList = new ArrayList<Component>();
        tooltipList.add((Component)Component.translatable((String)"item.pipe_connector.gui.tooltip.Pathfinding"));
        if (TagUtils.getBridgeType(itemStack) == BridgeType.DEFAULT) {
            tooltipList.add((Component)Component.translatable((String)"item.pipe_connector.gui.tooltip.defaultPathfindingImportantInfo").withStyle(ChatFormatting.GOLD));
            tooltipList.add((Component)Component.translatable((String)"item.pipe_connector.gui.tooltip.performanceImpact").withStyle(ChatFormatting.GRAY));
            tooltipList.add((Component)Component.translatable((String)"item.pipe_connector.gui.tooltip.performanceImpactLow").withStyle(ChatFormatting.YELLOW));
            return tooltipList;
        }
        if (TagUtils.getBridgeType(itemStack) == BridgeType.A_STAR) {
            tooltipList.add((Component)Component.translatable((String)"item.pipe_connector.gui.tooltip.aStarPathfindingImportantInfo").withStyle(ChatFormatting.GOLD));
            tooltipList.add((Component)Component.translatable((String)"item.pipe_connector.gui.tooltip.performanceImpact").withStyle(ChatFormatting.GRAY));
            tooltipList.add((Component)Component.translatable((String)"item.pipe_connector.gui.tooltip.performanceImpactMediumHigh").withStyle(ChatFormatting.YELLOW));
            return tooltipList;
        }
        return null;
    }
}

