/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils;

import com.heaser.pipeconnector.utils.NodeParameter;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;

public class PreviewInfo {
    public final BlockPos pos;

    public PreviewInfo(BlockPos pos) {
        this.pos = pos;
    }

    public boolean isRelativeStartPos(ItemStack pipeConnector) {
        NodeParameter startNode;
        List<NodeParameter> nodes = TagUtils.getNodesFromStack(pipeConnector);
        NodeParameter nodeParameter = startNode = nodes.isEmpty() ? null : nodes.getFirst();
        if (startNode == null) {
            return this.pos == null;
        }
        return this.pos.equals((Object)startNode.getRelativePosition());
    }

    public boolean isRelativeEndPos(ItemStack pipeConnector) {
        NodeParameter endNode;
        List<NodeParameter> nodes = TagUtils.getNodesFromStack(pipeConnector);
        NodeParameter nodeParameter = endNode = nodes.isEmpty() ? null : nodes.getLast();
        if (endNode == null) {
            return this.pos == null;
        }
        return this.pos.equals((Object)endNode.getRelativePosition());
    }

    public boolean isNode(ItemStack pipeConnector) {
        List<NodeParameter> nodes = TagUtils.getNodesFromStack(pipeConnector);
        List<BlockPos> nodeRelativePositions = nodes.stream().map(NodeParameter::getRelativePosition).toList();
        return nodeRelativePositions.contains(this.pos);
    }
}

