/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.network;

import com.heaser.pipeconnector.constants.BridgeType;
import com.heaser.pipeconnector.network.CustomPipeConnectorPayload;
import com.heaser.pipeconnector.network.ServerboundPacket;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.TagUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record UpdateBridgeTypePacket(String bridgeType) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateBridgeTypePacket> STREAM_CODEC = StreamCodec.ofMember(UpdateBridgeTypePacket::write, UpdateBridgeTypePacket::decode);
    public static final CustomPacketPayload.Type<UpdateBridgeTypePacket> TYPE = CustomPipeConnectorPayload.createType("update_bridge_type");

    public CustomPacketPayload.Type<UpdateBridgeTypePacket> type() {
        return TYPE;
    }

    public static UpdateBridgeTypePacket decode(RegistryFriendlyByteBuf buf) {
        return new UpdateBridgeTypePacket(buf.readUtf());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeUtf(this.bridgeType);
    }

    @Override
    public void handleOnServer(ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        if (!GeneralUtils.isHoldingPipeConnector((Player)sender)) {
            return;
        }
        TagUtils.setBridgeType(sender.getMainHandItem(), BridgeType.valueOf(this.bridgeType));
    }
}

