/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.gui.buttons;

import com.heaser.pipeconnector.client.ClientSetup;
import com.heaser.pipeconnector.client.gui.buttons.BaseButton;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockGetter;
import com.heaser.pipeconnector.config.PipeConnectorConfig;
import com.heaser.pipeconnector.constants.BridgeType;
import com.heaser.pipeconnector.network.BuildPipesPacket;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.NodeParameter;
import com.heaser.pipeconnector.utils.PipeConnectorUtils;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class BuildPipesButton
extends BaseButton {
    private final LocalPlayer player;

    public BuildPipesButton(LocalPlayer player) {
        super((Component)Component.translatable((String)"item.pipe_connector.gui.button.PlacePipes"), 20, 95);
        this.player = player;
    }

    @Override
    public void onClick(Button clickedButton, ItemStack itemStack) {
        PacketDistributor.sendToServer((CustomPacketPayload)new BuildPipesPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public boolean shouldClose() {
        return true;
    }

    @Override
    public boolean isActive(ItemStack itemStack) {
        return this.getErrorMessage(itemStack) == null;
    }

    @Override
    public Component getTooltip(ItemStack itemStack) {
        return this.getErrorMessage(itemStack);
    }

    private Component getErrorMessage(ItemStack itemStack) {
        List<NodeParameter> nodes = TagUtils.getNodesFromStack(itemStack);
        int existingPipes = PipeConnectorUtils.getNumberOfPipesInInventory((Player)this.player);
        int missingPipes = PipeConnectorUtils.getMissingPipesInInventory((Player)this.player, existingPipes, this.player.level(), ClientSetup.PREVIEW_DRAWER.previewMap, CompatibilityBlockGetter.getInstance().getBlock(this.player.getOffhandItem()));
        int maxAllowedPipes = (Integer)PipeConnectorConfig.MAX_ALLOWED_PIPES_TO_PLACE.get();
        Optional<BlockPos> inventoryBlockPos = this.pathContainsInventory();
        Optional<BlockPos> unbreakableBlockPos = this.pathContainsUnbreakableBlocks();
        if (nodes.size() < 2) {
            return Component.translatable((String)"item.pipe_connector.gui.button.tooltip.disabledPlacePipes");
        }
        if (!GeneralUtils.isPlaceableBlock((Player)this.player)) {
            return Component.translatable((String)"item.pipe_connector.gui.button.tooltip.disabledButtonHoldValidItem");
        }
        if (inventoryBlockPos.isPresent() && TagUtils.getPreventInventoryBlockBreaking(itemStack)) {
            String blockName = this.player.level().getBlockState(inventoryBlockPos.get()).getBlock().getName().getString();
            return Component.translatable((String)"item.pipe_connector.gui.button.tooltip.disabledInventoryInPath", (Object[])new Object[]{blockName});
        }
        if (unbreakableBlockPos.isPresent()) {
            String blockName = this.player.level().getBlockState(unbreakableBlockPos.get()).getBlock().getName().getString();
            return Component.translatable((String)"item.pipe_connector.message.unbreakableBlockReached", (Object[])new Object[]{blockName});
        }
        if (TagUtils.getBridgeType(itemStack) == BridgeType.A_STAR) {
            Set nodePositions = nodes.stream().map(NodeParameter::getRelativePosition).collect(Collectors.toSet());
            boolean anyNonNodePositions = ClientSetup.PREVIEW_DRAWER.previewMap.stream().anyMatch(preview -> !nodePositions.contains(preview.pos));
            if (!anyNonNodePositions) {
                return Component.translatable((String)"item.pipe_connector.gui.button.tooltip.noPathFound");
            }
        }
        if (ClientSetup.PREVIEW_DRAWER.previewMap.size() >= maxAllowedPipes) {
            return Component.translatable((String)"item.pipe_connector.gui.button.toolTip.maxAllowedPipesReached", (Object[])new Object[]{maxAllowedPipes});
        }
        if (missingPipes > 0) {
            return Component.translatable((String)"item.pipe_connector.gui.button.tooltip.disabledNotEnoughPipes", (Object[])new Object[]{missingPipes});
        }
        return null;
    }

    private Optional<BlockPos> pathContainsInventory() {
        return ClientSetup.PREVIEW_DRAWER.previewMap.stream().filter(block -> GeneralUtils.hasInventoryCapabilities(this.player.level(), block.pos)).map(block -> block.pos).findFirst();
    }

    private Optional<BlockPos> pathContainsUnbreakableBlocks() {
        return ClientSetup.PREVIEW_DRAWER.previewMap.stream().filter(block -> GeneralUtils.isNotBreakable(this.player.level(), block.pos)).map(block -> block.pos).findFirst();
    }
}

