/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.phantoms_utilities.network.server;

import dev.wp.phantoms_utilities.Util.PUColor;
import dev.wp.phantoms_utilities.items.SprayCan;
import dev.wp.phantoms_utilities.network.CustomPUPayload;
import dev.wp.phantoms_utilities.network.ServerBoundPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record SprayCanColorSelectPacket(@Nullable PUColor color) implements ServerBoundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, SprayCanColorSelectPacket> STREAM_CODEC = StreamCodec.ofMember(SprayCanColorSelectPacket::write, SprayCanColorSelectPacket::decode);
    public static final CustomPacketPayload.Type<SprayCanColorSelectPacket> TYPE = CustomPUPayload.createType("spray_can_select_color");

    public static SprayCanColorSelectPacket decode(RegistryFriendlyByteBuf stream) {
        PUColor color = null;
        if (stream.readBoolean()) {
            color = (PUColor)stream.readEnum(PUColor.class);
        }
        return new SprayCanColorSelectPacket(color);
    }

    private static void switchColor(ItemStack stack, PUColor color) {
        Item item;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof SprayCan) {
            SprayCan sprayCan = (SprayCan)item;
            sprayCan.setActiveColor(stack, color);
        }
    }

    public CustomPacketPayload.Type<SprayCanColorSelectPacket> type() {
        return TYPE;
    }

    public void write(RegistryFriendlyByteBuf data) {
        if (this.color != null) {
            data.writeBoolean(true);
            data.writeEnum((Enum)this.color);
        } else {
            data.writeBoolean(false);
        }
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        SprayCanColorSelectPacket.switchColor(player.getMainHandItem(), this.color);
        SprayCanColorSelectPacket.switchColor(player.getOffhandItem(), this.color);
    }
}

