/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.phantoms_utilities.network.server;

import dev.wp.phantoms_utilities.helpers.IMouseWheelItem;
import dev.wp.phantoms_utilities.network.CustomPUPayload;
import dev.wp.phantoms_utilities.network.ServerBoundPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record MWPacket(boolean wheelUp) implements ServerBoundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, MWPacket> STREAM_CODEC = StreamCodec.ofMember(MWPacket::write, MWPacket::decode);
    public static final CustomPacketPayload.Type<MWPacket> TYPE = CustomPUPayload.createType("mouse_wheel");

    public static MWPacket decode(RegistryFriendlyByteBuf byteBuf) {
        boolean wheelUp = byteBuf.readBoolean();
        return new MWPacket(wheelUp);
    }

    @NotNull
    public CustomPacketPayload.Type<MWPacket> type() {
        return TYPE;
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeBoolean(this.wheelUp);
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.getItemInHand(InteractionHand.OFF_HAND);
        Item item = mainHand.getItem();
        if (item instanceof IMouseWheelItem) {
            IMouseWheelItem mouseWheelItem = (IMouseWheelItem)item;
            mouseWheelItem.onScroll(mainHand, this.wheelUp);
        } else {
            item = offHand.getItem();
            if (item instanceof IMouseWheelItem) {
                IMouseWheelItem mouseWheelItem = (IMouseWheelItem)item;
                mouseWheelItem.onScroll(offHand, this.wheelUp);
            }
        }
    }
}

